<?php

namespace Ignite\Claim\Entities;

use Ignite\Core\Entities\User;

class OfferUser extends User
{
    public function promotionGroups()
    {
        return $this->belongsToMany(OfferPromotionGroup::class, 'claim_offer_user_promotion_group', 'user_id', 'promotion_group_id');
    }

    public function hasPromotionGroups()
    {
        return $this->hasMany(OfferUserPromotionGroup::class, 'user_id', 'user_id')
            ->select(['promotion_group_id', 'id']);
    }
}
