<?php

namespace Ignite\Claim\Providers;

use Ignite\Claim\Http\ViewComposers\StatesComposer;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Admin Claim Edit Pages
        view()->composer(
            ['Claim::admin.review', 'Claim::admin.edit'],
            'Ignite\Claim\Http\Views\IsAdminLayoutComposer'
        );

        view()->composer(['partials._forms._states'], StatesComposer::class);

        view()->composer('claim.index', \Ignite\Claim\Http\Views\ClaimSummaryComposer::class);
    }
}
