<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferPromotionGroup extends Model
{
    protected $table        = 'claim_offer_promotion_group';
    protected $primaryKey   = 'id';

    use ValidatesFields;

    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'name'                  => [ 'type' => 'string'],
        'description'           => [ 'type' => 'string'],
        'status'                => [ 'type' => 'integer',    'default' => '0'],
    ];

    public function promotions()
    {
        return $this->hasMany('Ignite\Claim\Entities\OfferPromotion', 'promotion_group_id', 'id');
    }

    public function hasPromotions()
    {
        return $this->hasMany('Ignite\Claim\Entities\OfferPromotion', 'promotion_group_id', 'id')
            ->select(['promotion_group_id', 'id']);
    }
}
