<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimRuleOfferTable extends Migration
{
    protected $tableName = 'claim_rule_offer';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('rule_id');
            $table->unsignedInteger('offer_id');
            $table->timestamps();
            $table->foreign('rule_id')->references('id')->on('claim_rule');
            $table->foreign('offer_id')->references('id')->on('claim_offer');
            $table->unique(['rule_id', 'offer_id'], 'claim_rule_offer');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
