var processClaimVue = new Vue({
  el: '#processClaimVue',
  data: {
    claimId : '',
    claimParticipantId : '',
    participantName : '',
    participantEmail : '',
    participantClaimValue : '',
    processDeclineReason : '',
    processDeclineCustom : ''
  },
  methods: {
    clearDeclineDialog: function() {
        this.participantName = '';
        this.participantEmail = '';
        this.participantClaimValue = '';
        this.participantReason = '';
        this.participantCustom = '';
    },
    showDeclineDialog: function(claimId, claimParticipantId) {
        var self = this;
        var token = $('[name=_token]').val();
        var submitData = {};

        self.clearDeclineDialog();

        self.claimId = claimId;
        self.claimParticipantId = claimParticipantId;

        submitData._token = token;
        submitData.claimId = claimId;
        submitData.claimParticipantId = claimParticipantId;

        axios.post('/admin/claim/api/claimparticipant', submitData)
            .then(function(response) {
                var claimParticipant = response.data.data;
                self.claimParticipantId = claimParticipant.id;
                self.claimId = claimParticipant.claim_id;
                self.participantName = claimParticipant.participant.first + ' ' + claimParticipant.participant.last;
                self.participantEmail = claimParticipant.participant_email;
                self.participantClaimValue = claimParticipant.value;
                $('#declineClaimDialog').modal('show');
            })
            .catch(function(response) {
                var messages = getResponseErrors(response, 'response.data.errors');
                alert('Unable to get Claim Participant Id = ' + claimParticipantId + ' for Claim Id = ' + self.$data.claimId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
            });
    },
    setClaimStatus: function(claimId, claimParticipantId, status) {
        var self = this;
        var token = $('[name=_token]').val();
        var submitData = {};

        self.claimId = claimId;
        self.claimParticipantId = claimParticipantId;

        submitData._token = token;
        submitData.claimId = claimId;
        submitData.claimParticipantId = claimParticipantId;
        submitData.status = status;

        if (status == 'declined') {
            submitData.declinedReasonCode = this.processDeclineReason;
            if (this.processDeclineReason == 'custom') {
                submitData.reason_declined = this.processDeclineCustom;
            }
        }

        axios.post('/admin/claim/api/setstatus', submitData)
            .then(function(response) {
                var result = response.data.result;
                $(window).off('beforeunload');
                location.reload();
            })
            .catch(function(response) {
                var messages = getResponseErrors(response, 'response.data.errors');
                alert("Unable to set status = '" + status + "' Claim Participant Id = " + claimParticipantId + ' for Claim Id = ' + self.$data.claimId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
            });
    },
    declineClaim: function() {
        if (this.processDeclineReason == '') {
            alert('Please select a Declined Reason.');
            return false;
        }
        this.processDeclineCustom = this.processDeclineCustom.trim();
        if (this.processDeclineReason == 'custom' && this.processDeclineCustom == '') {
            alert("You must enter a Custom Reason\nif Declined Reason selected is Custom Reason.");
            return false;
        }
        this.setClaimStatus(this.claimId, this.claimParticipantId, 'declined');
    },
    changeReason : function(event) {
        var $select = $(event.target);
        var $option = $select.find(':selected');
        var reasonValue = $option.val();
        var reasonText = $option.text();
        // alert('Reason: ' + this.processDeclineReason + ': ' + reasonText);
    }
  }
});
