<?php

namespace Ignite\Claim\Traits;

use Ignite\Claim\Entities\Table;

trait SupportTableSchema
{
    /**
     * @var \Illuminate\Support\Collection
     */
    protected $tableColumns;

    /**
     * Decorate the report with Table schema data.
     *a
     * @param  array $columns
     * @return array
     */
    protected function decorateTableSchema($columns)
    {
        $tables = $this->getTableColumns();

        foreach ($columns as $key => $column) {
            if ($tables->has($column['name'])) {
                $table = $tables->get($column['name']);
                $columns[$key]['title'] = $table['reportName'];
                $columns[$key]['sensitive'] = ($table['sensitive'] === '1');
            }
        }

        return $columns;
    }

    /**
     * Fetch the table columns for the provided column names.
     *
     * Example: [
     *   'core_user' => [
     *     'name' => 'foo',
     *     'reportName' => 'Foo'
     *   ]
     * ]
     *
     * @return \Illuminate\Support\Collection
     */
    protected function getTableColumns()
    {
        if (isset($this->tableColumns)) {
            return $this->tableColumns;
        }

        $fields = [];

        foreach (Table::all() as $table) {
            foreach ($table->static_columns as $column) {
                $fields[$table->name.'.'.$column['name']] = $column;
            }
        }

        return $this->tableColumns = collect($fields);
    }
}
