<?php

namespace Ignite\Claim\Http\Controllers;

use App;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Ignite\Core\Entities\Exception;
use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Repositories\ClaimRepository;
use Ignite\Claim\Models\CapCheck;
use Ignite\Claim\Repositories\OfferRepository;
use Ignite\Core\Repositories\TransactionRepository;

class ClaimAdminApiController extends Controller
{
    private $claimRepository;

    /**
     * Create a new controller instance.
     *
     * @param ClaimRepository $claimRepository
     */
    public function __construct(ClaimRepository $claimRepository)
    {
        $this->claimRepository = $claimRepository;
    }

    public function claimParticipantGet()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result   = true;
        $response->messages = [];

        try {
            $claimParticipantId = $data['claimParticipantId'];
            $response = $this->claimRepository->get([
                'class' => 'claim_participant',
                'action' => 'find',
                'mode' => 'array',
                'with' => ['participant'],
                'id' => $claimParticipantId
            ]);

            if (! $response->result) {
                $message = sprintf("Could not get Claim Participant for Id = '%s'.", $claimParticipantId);
                throw new Exception($message);
            }
        } catch (Exception $e) {
            $response->result = false;
            $response->data = false;
            $response->messages[] = $e->getMessage();
        }

        $httpCode = ($response->result) ? 200 : 422;
        return response(json_encode($response), $httpCode);
    }

    public function setStatus()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result   = true;
        $response->messages = [];

        try {
            $claimParticipantId = $data['claimParticipantId'];

            $status = $data['status'];

            $params = [];
            $params['class']                    = 'claim_participant';
            $params['action']                   = 'changeStatus';
            $params['claim_participant_id']     = $claimParticipantId;
            $params['status']                   = $status;

            // ---------------------------------------
            // Update the Claim Status
            // NOTE: Changing Claim Status this way causes other Business Logic
            //       to be executed.  Notably, Emails, and Promotion Cap enforcement.
            // ---------------------------------------
            if ($status == 'declined') {
                if (! empty($data['reason_declined'])) {
                    $params['reason_declined'] = $data['reason_declined'];
                } else {
                    $declinedReasons = ClaimParticipant::$declinedReasons;
                    if (! empty($data['declinedReasonCode'])) {
                        $reasonCode = $data['declinedReasonCode'];
                        $params['reason_declined'] = (! empty($declinedReasons[$reasonCode])) ? $declinedReasons[$reasonCode] : sprintf("Unknown Reason Code = '%s'.", $reasonCode) ;
                    }
                }
            }

            $response = $this->claimRepository->put($params);

            if (! $response->result) {
                $message = sprintf("Could not Update Claim Participant status to '%s' for Id = '%s'.", $data['status'], $claimParticipantId);
                // $message = implode("\n", $response->errors);
                throw new Exception($message);
            }
        } catch (Exception $e) {
            $response->result       = false;
            $response->data         = false;
            $response->messages[]   = $e->getMessage();
        }

        $httpCode = ($response->result) ? 200 : 422;
        return response(json_encode($response), $httpCode);
    }
}
