<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimOfferValueTable extends Migration
{
    protected $tableName = 'claim_offer_value';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('offer_id');
            $table->string('participant_type', 100);
            $table->tinyInteger('value_type_id');
            $table->double('value');
            $table->timestamps();
            $table->foreign('offer_id')->references('id')->on('claim_offer')->onDelete('cascade');
            $table->unique(['offer_id', 'participant_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
