(function($, window, document, undefined) {

    'use strict';

    window.SelectedItems = function(target) {
        return {
            items: $(target),
            has: function(item) {
                return -1 !== $.inArray(item, this.get());
            },
            add: function(item) {
                if (! this.has(item)) {
                    var items = this.get();
                    items.push(item);
                    this.set(items);
                }
                return this;
            },
            remove: function(item) {
                if (this.has(item)) {
                    var items = this.get();
                    items.splice(items.indexOf(item), 1);
                    this.set(items);
                }
                return this;
            },
            set: function(items) {
                this.items.val(items.join(','));
                return this;
            },
            get: function() {
                if (! this.items.val().length) {
                    return [];
                }

                return this.items.val().split(',').filter(function (i) {
                    return i.length ? i : false;
                });
            },
            count: function() {
                return this.get().length;
            }
        };
    };

})(window.jQuery, window, document);
