(function(window, document, undefined) {
    'use strict';

    window.filesVm = new Vue({
        el: '#filesVue',

        data: {
            files: window.uploadedFiles,
            uploadList: []
        },

        mounted: function() {
            this.documentTypes = window.documentTypes;

            for (var ii in this.files) {
                this.uploadList[ii] = this.files[ii];
            }
        },

        methods: {

            getNewFile: function() {
                return {
                    'fileId': 'new',
                    'documentType': '',
                    'fileName': 'files[]',
                    'storeFileName': '',
                    'documentType': ''
                };
            },

            getNewUploadInfo: function() {
                return {
                    'fileId': 'new',
                    'fileElement': null,
                    'fileName': '',
                    'storeFileName': '',
                    'documentType': ''
                };
            },

            addFile: function(){
                this.files.push(this.getNewFile());
                this.uploadList[this.uploadList.length] = this.getNewUploadInfo();
            },

            deleteFile: function(file){
                var index = this.files.indexOf(file);
                this.files.splice(index, 1);
                this.uploadList.splice(index, 1);
            },

            changeDocumentType: function(file, event){
                var index = this.files.indexOf(file);
                this.uploadList[index].documentType = this.files[index].documentType;
            },

            checkFileType: function(fileName) {
                var dotPos = fileName.lastIndexOf('.');
                var ext = fileName;

                if (dotPos > -1) {
                   ext = fileName.substring(dotPos+1);
                   ext = ext.toLowerCase();
                }

                if (typeof window.documentSuffixes[ext] !== 'undefined') {
                    return true;
                }

                return false;
            },

            changedFile: function(file, event){
                var fileElement = event.target.files[0];
                var index = this.files.indexOf(file);
                var fileName = fileElement.name;
                if (! this.checkFileType(fileName)) {
                    alert('File "' + fileName + '" on line ' + (index+1) + ' was not an allowed file type.');
                    this.deleteFile(file);
                    return false;
                }
                this.uploadList[index].fileElement = fileElement;
            },

            checkRequiredDocuments: function() {
                for(var ii in this.documentTypes) {
                    var documentType = this.documentTypes[ii];
                    var count = 0;
                    for (var jj in this.uploadList) {
                        if (this.uploadList[jj].documentType === '') {
                            alert("You haven't selected a Document Type for line " + (count+1) + '.');
                            return false;
                        }
                        if (this.uploadList[jj].fileElement === null && this.uploadList[jj].storeFileName === '') {
                            alert("You need to Choose a File for " + this.uploadList[jj].documentType + ' on line ' + (count+1) + '.');
                            return false;
                        }
                        if (this.uploadList[jj].documentType === documentType.name) {
                            ++count;
                        }
                    }
                    if (count < documentType.min) {
                        alert("You must provide at least " + documentType.min + ' ' + documentType.name + '(s).');
                        return false;
                    }
                    if (count > documentType.max) {
                        alert("You can only provide " + documentType.max + ' ' + documentType.name + '(s).');
                        return false;
                    }
                }

                return true;
            },

            uploadFiles: function(showConfirmation) {
                if (! this.checkRequiredDocuments()) {
                    return false;
                }

                for (var index in this.uploadList) {
                    if (this.uploadList.hasOwnProperty(index)) {
                        var uploadInfo = this.uploadList[index];
                        if (uploadInfo.storeFileName !== '') {
                            continue;
                        }
                        if (!uploadFile(uploadInfo, index)) {
                            alert("Problem uploading file " + uploadInfo.fileElement.name);
                            return false;
                        }
                    } else {
                        alert('No file in the upload list to send');
                    }
                }

                if (showConfirmation) {
                    alert("Files Uploaded Successfully.");
                }

                return true;
            },

        }

    });

    //---------------------------------------------
    // Best XHR Example: https://gist.github.com/ebidel/2410898
    // Good AJAX Example: https://stackoverflow.com/questions/30284729/how-to-upload-file-via-ajax-in-laravel-5
    //---------------------------------------------
    function uploadFile(uploadInfo, index)
    {
        var formData = new FormData();
        var $token = $('[name="_token"]');
        var code = $('#filesCode').val();

        formData.append('related_type', 'temp');
        formData.append('related_name', 'claim');
        formData.append('related_id', code);

        formData.append('file', uploadInfo.fileElement);

        var xhr = new XMLHttpRequest();
        xhr.open('POST', '/file/store', false);

        xhr.setRequestHeader('X-CSRF-Token', $token.val());

        xhr.upload.onprogress = function(e) {
            if (e.lengthComputable) {
                var percentComplete = (e.loaded / e.total) * 100;
                //console.log(percentComplete + '% uploaded');
            }
        };

        xhr.onload = function() {
            if (this.status == 200) {
                var response = JSON.parse(this.response);
                uploadInfo.fileName = response.data.fileName;
                uploadInfo.storeFileName = response.data.storeFileName;
              }
            else {
                var message = '';
                if (typeof this.response.data != 'undefined') {
                    message += this.response.data.messages.join("\n");
                }
                message += 'Http Error: ' + this.status + ': ' + this.statusText;
                alert(message);
                return false;
            }
        };

        xhr.send(formData);

        return true;
    }
})(window, document);
