<?php

namespace Ignite\Claim\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Ignite\Claim\Models\Grid\PromotionTable;
use Ignite\Claim\Entities\OfferCampaign;

class PromotionsController extends Controller
{
    /**
     * Show a list of available promotions.
     *
     * @param  int            $campaignId
     * @param  PromotionTable $table
     * @param  Request        $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function index($campaignId = 0, PromotionTable $table, Request $request)
    {
        $campaigns = OfferCampaign::query()->onlyActive()->orderBy('name')->get();

        $table->with('campaign_id', $campaignId);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Claim::admin.promotions.index', compact(
            'campaigns',
            'campaignId'
        ));
    }
}
