@if (! empty($participant))
    <div class="box box-primary">
        <div class="box-body box-profile">
            <h3 class="profile-username text-center">{{ $participant['first'] }} {{ $participant['last'] }}</h3>
            <p class="text-muted text-center">{{ $participant['type'] }}</p>
            <ul class="list-group list-group-unbordered">
                @foreach ($participant as $key => $value)
                    @if (! empty(trim($value)) && ! in_array($key, ['first', 'last', 'type', 'ssn']))
                    <li class="list-group-item">
                        <strong>{{ str_replace('_', ' ', title_case($key)) }}</strong> <a class="pull-right">{{ $value }}</a>
                    </li>
                    @endif
                @endforeach
            </ul>
            <a href="{{ route('admin.participant.show', $participant['user_id']) }}" class="btn btn-primary btn-block">
                <strong>View Participant</strong>
            </a>
        </div>
    </div>
@endif
