var newValueItem = {
  'id': 'new',
  'participant_type': '',
  'value_type_id': '1',
  'value': 0
};

var newOfferItem = {
  'id': 'new',
  'promotion_id': '',
  'name': '',
  'description': '',
  'sku': '',
  'offer_group': 'Default',
  'start_date': '',
  'end_date': '',
  'grace_date': '',
  'value_mode_id': '1',
  'value_type_id': '1',
  'value': 0,
  'status': '1',
  'values': []
};

function setDialogMode(mode) {
  if (mode === 'add') {
    $('#offerEditLabel').html('Create Offer');
    $('#offerAction').val('new');
    $('#offerSave').html('Create');
  } else if (mode === 'delete') {
    $('#offerEditLabel').html('Delete Offer');
    $('#offerAction').val('delete');
    $('#offerSave').addClass('btn-danger').html('Delete');
  } else {
    $('#offerEditLabel').html('Edit Offer');
    $('#offerAction').val('update');
    $('#offerSave').html('Update');
  }
}

new Vue({
  el: '#offersVue',
  data: {
    valueItems: [],
    formErrors: {},
    formErrorsUpdate: {},
    offerId: 1,
    offer: newOfferItem,
    editValueIndex: 0,
    editValueItem: {'id': '', 'participant_type': '', 'value_type_id': '', 'value': ''},
    skuchange: false
  },

  mounted() {
    var options = {
      format: 'mm/dd/yyyy',
      autoclose: true,
      pickDate: true
    };

    var self = this;

    $('#offerStartDate').datepicker(options).on('change', function () {
      self.offer.start_date = $('#offerStartDate').val();
    });

    $('#offerEndDate').datepicker(options).on('change', function () {
      self.offer.end_date = $('#offerEndDate').val();
    });

    $('#offerGraceDate').datepicker(options).on('change', function () {
      self.offer.grace_date = $('#offerGraceDate').val()
    });
  },

  methods: {
    validateValueRow: function (mode, valueItem) {
      var type = $('#valueName').val();
      var value = $('#valueValue').val().trim();

      if (valueItem.participant_type.trim() === '') {
        alert('Please select a Participant Type.');
        return false;
      }

      if (valueItem.value.trim() === '' || isNaN(value)) {
        alert('Please enter a Number for Value.');
        return false;
      }

      var typeUsed = false;
      for (var rowIndex in this.offer.values) {
        if (this.offer.values.hasOwnProperty(rowIndex)) {
          var tmpValueItem = this.offer.values[rowIndex];
          if (tmpValueItem.participant_type === valueItem.participant_type) {
            if (mode === 'add' || rowIndex !== this.editValueIndex) {
              typeUsed = true;
              break;
            }
          }
        }
      }

      if (typeUsed) {
        alert("Participant Type already in Values list.\nPlease select a different Participant Type.");
        return false;
      }

      return true;
    },
    newValue: function () {
      this.editValueItem = $.extend(true, {}, newValueItem);
      $("#valueSave").addClass('hidden');
      $("#valueAdd").removeClass('hidden');
      $("#valueEditDialog").modal('show');
    },
    addValue: function () {
      if (!this.validateValueRow('add', this.editValueItem)) {
        return false;
      }

      this.offer.values[this.offer.values.length] = this.editValueItem;
      this.editValueItem = $.extend(true, {}, newValueItem);
      $("#valueEditDialog").modal('hide');
    },
    deleteValue: function (index) {
      var valueItems = [];
      count = 0;
      for (var i in this.offer.values) {
        if (this.offer.values.hasOwnProperty(i)) {
          if (i === index) {
            continue;
          }
          valueItems[count] = this.offer.values[i];
          ++count;
        }
      }
      this.offer.values = valueItems;
      Ignite.Core.flash('Item deleted successfully.', 'success', 2000);
    },
    editValue: function (valueItem, index) {
      this.editValueIndex = index;
      this.editValueItem = $.extend(true, {}, valueItem);

      $("#valueSave").removeClass('hidden');
      $("#valueAdd").addClass('hidden');
      $("#valueEditDialog").modal('show');
    },
    updateValue: function (index) {
      if (!this.validateValueRow('edit', this.editValueItem)) {
        return false;
      }

      this.offer.values[index] = this.editValueItem;
      this.editValueItem = $.extend(true, {}, newValueItem);
      $("#valueEditDialog").modal('hide');
    },
    renderValueType: function (valueTypeId) {
      var valueTypeText = '';

      if (typeof (valueTypeOptions[valueTypeId]) != 'undefined') {
        valueTypeText = valueTypeOptions[valueTypeId];
      }

      return valueTypeText;
    },
    renderDate: function (dateIn) {
      return (parseInt(dateIn) > 0) ? moment(dateIn).format('M/D/YYYY') : '';
    },
    newOffer: function () {
      this.offer = $.extend(true, {}, newOfferItem);
      this.offer.promotion_id = $('#promotionId').val();
      $('[name="offerValueModeId"][value="' + this.offer.value_mode_id + '"]').trigger('change');

      setDialogMode('add');
      $("#offerEditDialog").modal('show');
    },
    getOffer: function (id) {
      var self = this;
      var offerId = id;

      axios.get('/offer/api/offer/get/' + id)
        .then(function (response) {
          self.offer = response.data.data;
          self.offer.start_date = self.renderDate(self.offer.start_date);
          self.offer.end_date = self.renderDate(self.offer.end_date);
          self.offer.grace_date = self.renderDate(self.offer.grace_date);
          $('[name="offerValueModeId"][value="' + self.offer.value_mode_id + '"]').trigger('change');
        })
        .catch(function (response) {
          var messages = window.Ignite.Core.getResponseErrors(response, 'response.data.messages');
          alert('Unable to Get Offer for Id = ' + offerId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
        });
    },
    editOffer: function (id) {
      this.getOffer(id);
      setDialogMode('edit');
      $("#offerEditDialog").modal('show');
    },
    saveOffer: function () {
      var self = this;
      var token = $('[name=_token]').val();
      var action = $('#offerAction').val();

      if (! self.offer.name.length || ! self.offer.sku.length) {
        return;
      }

      var data = $.extend(true, {}, this.offer);
      data._token = token;
      axios.post('/offer/api/offer/store', data)
        .then(function (response) {
          self.offer = $.extend(true, {}, newOfferItem);
          $("#offerEditDialog").modal('hide');

          Ignite.Core.flash('Offer saved successfully.', 'success', 4000);
          setTimeout(function() {
            window.location.reload();
          }, 3000);
        })
        .catch(function (response) {
          var message = '';
          var messages = window.Ignite.Core.getResponseErrors(response, 'response.data.messages');
          if (data.id === 'new') {
            message = 'Unable to Create New Offer' + "\n" + messages + response.response.status + ': ' + response.response.statusText;
          } else {
            message = 'Unable to Save Offer for Id = ' + data.id + "\n" + messages + response.response.status + ': ' + response.response.statusText
          }
          window.Ignite.Core.flash(message, 'error', 4000);
        });
    },

    deleteOffer: function (id) {
      if (window.confirm('Are you sure you want to delete this offer?')) {
        id = id || self.offer.id;
        var token = $('[name=_token]').val();
        axios.post('/offer/api/offer/delete', {'offer_id': id, '_token': token})
          .then(function (response) {
            window.Ignite.Core.flash('Offer deleted successfully.', 'success', 4000);
            setTimeout(function() {
              window.location.reload();
            }, 3000);
          })
          .catch(function (response) {
            var messages = window.Ignite.Core.getResponseErrors(response, 'response.data.messages');
            if (messages.match(/(SQLSTATE\[23000\])/g)) {
              messages = 'This offer is associated with at least one claim, please delete all associated claims before trying again.';
            }
            window.Ignite.Core.flash("Error: " + messages, 'error', 4000);
          });
      }
    },

    syncSku: function() {
      if (! this.skuchange) {
        this.offer.sku = this.offer.name.toLowerCase().replace(/[^a-z0-9]+|\s+/gmi, '_').replace(/[\-]+$/g, '');
      }
    }
  }
});
