<?php

namespace Ignite\Claim\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Claim\Models\Grid\ParticipantClaimTable;

class ParticipantClaimsController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private $participantRepository;

    /**
     * ParticipantClaimsController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * Show the Claim that belong to the provided participant.
     *
     * @param  bool|int              $participantId
     * @param  string                $status
     * @param  ParticipantClaimTable $table
     * @param  Request               $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     * @throws \Ignite\Packages\Presenter\Exceptions\PresenterException
     */
    public function index($participantId, $status = 'all', ParticipantClaimTable $table, Request $request)
    {
        $status = empty(trim($status)) ? 'all' : strtolower($status);
        session()->put('participantClaimListType', $status);
        $participant = $this->participantRepository->find($participantId)->present();

        $table->with('status', $status);
        $table->with('user_id', $participantId);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Claim::admin.participant.claims.index', compact(
            'status', 'participant', 'participantId'
        ));
    }
}
