<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferPromotion extends Model
{
	use ValidatesFields;

    const STATUS_ACTIVE = 1;
    const STATUS_INACTIVE = 0;

    /**
     * @var string
     */
    protected $table = 'claim_offer_promotion';

    /**
     * @var string
     */
    protected $primaryKey   = 'id';

    /**
     * @var array
     */
    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'campaign_id'           => [ 'type' => 'integer'],
        'promotion_group_id'    => [ 'type' => 'integer'],
        'name'                  => [ 'type' => 'string'],
        'description'           => [ 'type' => 'string'],
        'html'                  => [ 'type' => 'string'],
        'start_date'            => [ 'type' => 'date'],
        'end_date'              => [ 'type' => 'date'],
        'status'                => [ 'type' => 'integer', 'default' => '0'],
    ];

    /**
     * The relationship to offers for this promotion.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function offers()
    {
        return $this->hasMany('Ignite\Claim\Entities\Offer', 'promotion_id', 'id');
    }

    /**
     * The relationship to caps for this promotion.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function caps()
    {
        return $this->hasMany('Ignite\Claim\Entities\OfferPromotionCap', 'offer_promotion_id', 'id');
    }

    /**
     * The relationship to offers for this promotion.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function hasOffers()
    {
        return $this->hasMany('Ignite\Claim\Entities\Offer', 'promotion_id', 'id')->select(['promotion_id', 'id']);
    }

    /**
     * Scope a query to only include active promotions.
     *
     * @param $query
     */
    public function scopeOnlyActive($query)
    {
        $query->where('status', static::STATUS_ACTIVE);
    }
}
