@extends('Core::layouts.main')

@php
    $title = ($mode == 'new' ? 'Review Claim' : 'Review Claim #' . $formData['claim_participant']['id']) ;
@endphp

@section('page_heading', $title)

@section('page_breadcrumb', $title)

@section('page_content')
    <div class="row">
        <div class="col-md-3">
            @include('Claim::admin.partials.menu', ['formData' => $formData])
            @include('Claim::admin.partials.participant', ['participant' => $formData['claim_participant']['participant'] ?? []])
        </div>
        <div class="col-sm-9">
            <div class="box box-primary">
                <div class="box-body">
                        @if(! empty($isAdminLayout))
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <div class="panel-title">
                                    <strong>External Fields</strong>
                                </div>
                            </div>
                        @else
                        <div class="panel panel-default">
                        @endif
                            <div class="panel-body">
                                @include('Claim::partials.claimReviewFieldsExternal')
                            </div>
                        </div>

                        @if(! empty($isAdminLayout) && $mode != 'new')
                        <div class="panel panel-default" style="border: 1px solid #cccccc;">
                            <div class="panel-heading">
                                <div class="panel-title">
                                    <strong>Internal (Claim Participant) Fields</strong>
                                </div>
                            </div>
                            <div class="panel-body">
                                @include('Claim::partials.claimReviewFieldsInternal')
                            </div>
                        </div>
                        @endif

                        @if ($mode == 'new')
                            @include('Claim::partials.claimReviewParticipants_static')
                        @endif

                        @include('Claim::partials.claimReviewItems_static')

                        @if (! empty($documentTypes))
                            @include('Claim::partials.claimReviewFiles')
                        @endif

                        @include('Claim::partials.claimReviewButtons')
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
