@extends('Core::layouts.main')

@section('meta_title', 'Offer Management')

@section('css')
    @parent
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css"/>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.offer.index') }}">Offer Management</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.offer.index') }}">Offer Management</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@php
$activeKey = request()->segment(3);
$tabs = [
    // 'campaigns'        => 'Campaigns',  // disabling campaigns tab
    'promotiongroups'     => 'Promotion Groups',
    'promotions'          => 'Promotions',
    'offers'              => 'Offers',
    'userpromotiongroups' => 'User Promotion Groups',
];
@endphp

@section('page_content')
    @yield('tab_before')
    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            @foreach($tabs as $tabKey => $tabLabel)
                <li class="{{ (strtolower($activeKey) == $tabKey) ? 'active' : '' }}">
                    <a href="/admin/offer/{{ $tabKey }}">{{ $tabLabel }}</a>
                </li>
            @endforeach
            <li class="nav-tabs-custom-toolbar col-xs-4 pull-right">
                <div class="box-tools clearfix pull-right" id="dtButtons">
                    @yield('tab_buttons')
                </div>
            </li>
        </ul>
        <div class="tab-content">
            @yield('tab_content')
        </div>
    </div>
    @yield('tab_after')
@endsection

@section('js')
    @parent
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
@endsection
