(function($, window, document, undefined) {

    'use strict';

    window.ReasonModal = function(options) {
        this.settings = $.extend({
            model: '#reason-dialog',
            title: '#reason-dialog-title',
            titleText: 'Enter Reason',
            label: '#reason-dialog-label',
            labelText: 'Reason',
            cancel: '#reason-dialog-cancel',
            button: '#reason-dialog-proceed',
            buttonText: 'Continue',
            buttonType: 'btn-success',
            reason: '#reason-note',
            container: '#reason-note-field',
            error: '#reason-note-error',
            required: false,
            minLength: 10,
            onSuccess: false,
            onFailure: false
        }, options);

        $(this.settings.model)
            .on('show.bs.modal', $.proxy(function() {
                $(this.settings.title).text(this.settings.titleText);
                $(this.settings.label).text(this.settings.labelText);
                $(this.settings.button).text(this.settings.buttonText).addClass(this.settings.buttonType);

                $(document).off().on('click', this.settings.button, $.proxy(function(e) {
                    e.preventDefault();

                    var $reason = $(this.settings.reason);
                    var $reasonText = $.trim($reason.val());

                    if (! this.settings.required) {
                        return this.settings.onSuccess.apply(this, [$reasonText]);
                    }

                    if ($reasonText.length > this.settings.minLength) {
                        $(this.settings.container).removeClass('has-error');
                        $(this.settings.error).addClass('hide').text('');
                        return this.settings.onSuccess.apply(this, [$reasonText]);
                    } else {
                        $(this.settings.container).addClass('has-error');
                        $(this.settings.error).removeClass('hide');
                        return this.settings.onFailure.apply(this, [$reasonText, $(this.settings.error)]);
                    }
                }, this));
            }, this))
            .on('hide.bs.modal', $.proxy(function() {
                $(this.settings.container).removeClass('has-error');
                $(this.settings.error).addClass('hide').text('');
                $(this.settings.reason).val('');
            }, this))
            .modal('show');
    };

})(window.jQuery, window, document);
