<?php

namespace Ignite\Claim\Database\Seeders;

use Ignite\Claim\Entities\Setting;
use Ignite\Core\Database\Seeders\AbstractSeeder;

class SettingTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        /* TODO: Create a repository class for Settings
        $settingRepository = app(PageRepository::class); */
        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/settings.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Setting::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
