<?php

namespace Ignite\Claim\Http\Controllers\Admin;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Claim\Models\Form as FormModel;
use Ignite\Claim\Models\ClaimUtil;
use Ignite\Claim\Entities\Form;
use Ignite\Claim\Repositories\ClaimRepository;
use Ignite\Core\Repositories\ParticipantRepository;

class QuickviewController extends Controller
{
    /**
     * @var ClaimRepository
     */
    protected $claimRepository;

    /**
     * @var ParticipantRepository
     */
    protected $participantRepository;

    /**
     * @var ClaimUtil
     */
    protected $claimUtil;

    /**
     * Create a new process controller instance.
     *
     * @param ClaimRepository $claimRepository
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ClaimRepository $claimRepository, ParticipantRepository $participantRepository)
    {
        $this->claimRepository = $claimRepository;
        $this->participantRepository = $participantRepository;
        $this->claimUtil = new ClaimUtil($this->participantRepository);
    }

    /**
     * Quick view of the claim with claim participant.
     *
     * @param int $claimParticipantId
     * @param int $claimId
     * @return \Illuminate\View\View
     */
    public function show($claimParticipantId, $claimId)
    {
        $claimFieldsExternalKey = 'form.claim.partial.claim_fields_external';
        $claimFieldsInternalKey = 'form.claim.partial.claim_fields_internal';

        $review = false;
        $errors = [];
        $params = [
            'id' => $claimId,
            'class' => 'claim',
            'action' => 'find',
            'mode' => 'array',
            'with' => [
                'lineItems',
                'claim_participants',
                'claim_participants.participant',
                'documents'
            ]
        ];

        $response = $this->claimRepository->get($params);
        $formData = $response->data;

        // Get Specific Claim Participant
        $claimParticipant = false;
        foreach ($formData['claim_participants'] as $participant) {
            if ($participant['id'] == $claimParticipantId) {
                $claimParticipant = $participant;
            }
        }

        $formData['claim_items'] = $formData['line_items'];
        $formData['claim_participant'] = $claimParticipant;

        unset($formData['line_items']);
        unset($formData['claim_participants']);

        $claimFormSettings = Form::findByKey($claimFieldsExternalKey);
        $internalClaimFormSettings =  Form::findByKey($claimFieldsInternalKey);

        $claimFields = FormModel::mergeFormFieldData(
            'claim',
            $formData,
            $claimFormSettings,
            $review,
            $errors
        );

        $internalClaimFields = FormModel::mergeFormFieldData(
            'claim_participant',
            $formData['claim_participant'],
            $internalClaimFormSettings,
            $review,
            $errors
        );

        // Get Various Dropdown Options
        $documentTypes = $this->claimUtil->getDocumentTypes();
        $documentSuffixes = $this->claimUtil->getDocumentSuffixes();

        $data = [
            'claimParticipantId'  => $claimParticipantId,
            'documentTypes'       => $documentTypes,
            'documentSuffixes'    => $documentSuffixes,
            'formData'            => $formData,
            'claimFields'         => $claimFields,
            'internalClaimFields' => $internalClaimFields,
        ];

        return view('Claim::admin.quickview', $data);
    }
}
