@extends('Claim::layouts.tables')

@php $pageTitle = 'Edit ' . ucwords($tableModel->name) . ' Table'; @endphp

@section('page_heading', $pageTitle)
@section('page_breadcrumb', $pageTitle)

@section('page_content')

    @if (! empty($infos))
        <div class="alert alert-info">
            <ul class="list-unstyled">
                @foreach($infos as $info)
                    <li>{{ $info }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li class="active"><a href="#columns-static" data-toggle="tab">Static Columns</a></li>
            <li><a href="#columns-dynamic" data-toggle="tab">Dynamic Columns</a></li>
            <li class="nav-tabs-custom-toolbar pull-right">
                <div class="box-tools"></div>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="columns-static">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix">
                        <div class="pull-left">
                            <h3 style="margin: 0;">
                                Static Columns
                                <span class="badge" id="staticColumnCount">{{ count($tableModel->static_columns) }}</span>
                            </h3>
                            <h5 class="help help-block pull-right">The columns are defined on the database and only certain data can be changed.</h5>
                        </div>
                        <div class="pull-right">
                            @if ($dbColumnsChanged)
                                <button type="button" class="btn btn-sm btn-danger" id="syncDbColumns">Sync DB Columns
                                </button>
                            @endif
                        </div>
                    </div>
                    <div class="panel-body">
                        <table class="table static_columns" id="dbColumnsTable" width="100%">
                            <thead>
                            <tr>
                                <th>&nbsp;</th>
                                <th>Name</th>
                                <th>Display Name</th>
                                <th>Report Name</th>
                                <th>Type</th>
                                <th>Null</th>
                                <th>System Required</th>
                                <th>Sensitive</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if (count($tableModel->static_columns) > 0 )
                                @foreach($tableModel->static_columns as $dbColumn)
                                    <tr data-column_name="{{ $dbColumn['name'] }}">
                                        <td align="left" nowrap>
                                            <button type="button" class="btn btn-sm btn-default editStaticColumn" data-column_name="{{ $dbColumn['name'] }}">Edit</button>
                                        </td>
                                        <td data-name="name">{{ $dbColumn['name'] }}</td>
                                        <td data-name="displayName">{{ $dbColumn['displayName'] }}</td>
                                        <td data-name="reportName">{{ $dbColumn['reportName'] }}</td>
                                        <td data-name="type">{{ $dbColumn['type'] }}</td>
                                        <td data-name="null" data-boolean="1">{{ ($dbColumn['null']) ? 'Yes' : 'No' }}</td>
                                        <td data-name="required" data-boolean="1">{{ ($dbColumn['required']) ? 'Yes' : 'No' }}</td>
                                        <td data-name="sensitive" data-boolean="1">{{ (isset($dbColumn['sensitive']) && $dbColumn['sensitive'] == 1) ? 'Yes' : 'No' }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="noRows">
                                    <td colspan="7" class="text-danger text-center">No static columns found.</td>
                                </tr>
                            @endif
                            </tbody>
                        </table>
                    </div> <!-- panel-body -->
                </div> <!-- panel -->
            </div>
            <div class="tab-pane" id="columns-dynamic">
                @if ($isDynamic)
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title clearfix">
                                <div class="pull-left">
                                    <h3 style="margin: 0;">
                                        Dynamic Columns
                                        <span class="badge" id="dynamicColumnCount">{{ count($tableModel->dynamic_columns) }}</span>
                                    </h3>
                                    <h5 class="help help-block pull-right">The columns are defined as dynamic json configuration and stored in the settings.</h5>
                                </div>
                                <div class="pull-right">
                                    <button type="button" class="btn btn-default" id="addDynamicColumn" data-name="new"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
                                </div>
                            </h3>
                        </div>
                        <div class="panel-body">
                            <table id="dynamicColumnsTable" class="table dynamic_columns {{ count($tableModel->dynamic_columns) > 0 ? 'has-columns' : 'has-no-columns' }}">
                                <thead>
                                    <tr>
                                        <th>&nbsp;</th>
                                        <th>Name</th>
                                        <th>Display Name</th>
                                        <th>Report Name</th>
                                        <th>Type</th>
                                        <th>Null</th>
                                        <th>System Required</th>
                                        <th>Sensitive</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @if (count($tableModel->dynamic_columns) > 0 )
                                    @foreach($tableModel->dynamic_columns as $name => $dynamicColumn)
                                        <tr data-column_name="{{ $dynamicColumn['name'] }}">
                                            <td width="100" align="left" nowrap>
                                                <button type="button" class="btn btn-sm btn-default editDynamicColumn" data-column_name="{{ $dynamicColumn['name'] }}">Edit</button>
                                                <button type="button" class="btn btn-sm btn-danger deleteDynamicColumn" data-column_name="{{ $dynamicColumn['name'] }}">Delete</button>
                                            </td>
                                            <td data-name="name">{{ $dynamicColumn['name'] }}</td>
                                            <td data-name="displayName">{{ $dynamicColumn['displayName'] }}</td>
                                            <td data-name="reportName">{{ $dynamicColumn['reportName'] }}</td>
                                            <td data-name="type">{{ $dynamicColumn['type'] }}</td>
                                            <td data-name="null" data-boolean="1">{{ isset($dynamicColumn['null']) ? 'Yes' : 'No' }}</td>
                                            <td data-name="required" data-boolean="1">{{ isset($dynamicColumn['required']) ? 'Yes' : 'No' }}</td>
                                            <td data-name="sensitive" data-boolean="1">{{ (isset($dynamicColumn['sensitive']) && $dynamicColumn['sensitive'] === 1) ? 'Yes' : 'No' }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr class="noRows">
                                        <td colspan="7" class="text-danger text-center">No dynamic columns created yet.</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                        </div> <!-- panel-body -->
                    </div> <!-- panel -->
            </div>
        @endif <!-- if ( isDynamic ) -->
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="box box-primary">
        <div class="box-footer">
            <button type="button" class="btn btn-danger pull-left" id="cancelTable">Cancel</button>
            <button type="button" class="btn btn-primary pull-right" id="saveTable">Save</button>
        </div>
    </div>

    <!-- Modal Edit Dialog -->
    <div class="modal " id="columnEditDialog" tabindex="-1" role="dialog" aria-labelledby="columnEditLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title" id="columnEditLabel">Column Details</h3>
                </div>
                <div class="modal-body">
                    <form id="editColumnForm">
                        {{ csrf_field() }}
                        <input type="hidden" id="editColumnName" value=""/>
                        <input type="hidden" id="editMode" value=""/>
                        <input type="hidden" id="editType" value=""/>


                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label for="columnName">Name</label>
                                <input type="text" class="form-control dynamicColumn" id="columnName" name="columnName" data-name="name" required/>
                                <div class="controls readOnlyText staticColumn" id="columnName" name="columnName" data-name="name"></div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label for="columnReportName">Report Name</label>
                                <input type="text" class="form-control" id="columnReportName" name="columnReportName" data-name="reportName"/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label for="columnDisplayName">Display Name</label>
                                <input type="text" class="form-control" id="columnDisplayName" name="columnDisplayName" data-name="displayName"/>
                            </div>
                            <div class="form-group col-sm-6">
                                <label for="columnType">Type</label>
                                <select class="form-control dynamicColumn" id="columnType" name="columnType" data-name="type" required>
                                    <option value="">--- select ---</option>
                                    @foreach($columnTypes as $type => $params)
                                        <option value="{{ $type }}">{{ $type }}</option>
                                    @endforeach
                                </select>
                                <div class="controls readOnlyText staticColumn" id="columnType" name="columnType" data-name="type"></div>
                            </div>
                        </div>

                        <div class="row" style="margin: 15px 0;">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4" style="margin-bottom: 0;">
                                    <input type="checkbox" class="staticColumn" id="columnNull" name="columnNull" data-name="null" value="1" disabled/>
                                    <input type="checkbox" class="dynamicColumn" id="columnNull" name="columnNull" data-name="null" value="1"/>
                                    <label for="columnNull" class="text-left">Null</label>
                                </div>
                                <div class="form-group col-sm-4" style="margin-bottom: 0;">
                                    <input type="checkbox" id="columnRequired" name="columnRequired" data-name="required" value="1"/>
                                    <label for="columnRequired" class="text-left">System Required</label>
                                </div>
                                <div class="form-group col-sm-4" style="margin-bottom: 0;">
                                    <input type="checkbox" id="columnSensitive" name="columnSensitive" data-name="sensitive" value="1"/>
                                    <label for="columnSensitive" class="text-left">Has Sensitive Data</label>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label for="columnFormat">Format</label>
                                <input type="text" class="form-control" id="columnFormat" name="columnFormat" data-name="format"/>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="columnValidateType">Validation Type</label>
                                <select class="form-control" id="columnValidateType" name="columnValidateType" data-name="validateType">
                                    <option value="">--- select ---</option>
                                    @foreach($validateTypes as $type => $params)
                                        <option value="{{ $type }}">{{ $type }}</option>
                                    @endforeach
                                </select>

                                <div class="form-group hidden" id="customValidate">
                                    <br/>
                                    <label for="columnValidate">Custom Laravel Validation String</label>
                                    <input type="text" class="form-control" id="columnValidate" name="columnValidate" data-name="validate"/>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="columnOptions">Options</label>
                            <textarea class="form-control" id="columnOptions" name="columnOptions" rows="5" cols="50" data-name="options"></textarea>
                        </div>

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary hidden" id="columnSave">Save</button>
                    <button type="button" class="btn btn-primary hidden" id="columnAdd">Add</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    @parent
    <script src="{{ asset('/vendor/ignite/js/dynamic/dynamic.js') }}"></script>
    <script type="text/javascript">
        var dirtyFlag = false;
        {{--//var setting = {!! json_encode($setting, JSON_PRETTY_PRINT) !!} ; --}}
        var formFields = {!! json_encode($formFields, JSON_PRETTY_PRINT) !!} ;
        var tableModel = {!! json_encode($tableModel, JSON_PRETTY_PRINT) !!} ;

        $(document).ready(function () {

            function clearColumnEditDialog() {
                editColumnValidator.resetForm();
                $('#columnEditDialog [data-name]').removeClass('error');
                $('#columnName').val('');
                $('#columnDisplayName').val('');
                $('#columnReportName').val('');
                $('#columnType').val('');
                $('#columnNull').attr('checked', false);
                $('#columnRequired').attr('checked', false);
                $('#columnSensitive').attr('checked', false);
                $('#columnFormat').val('');
                $('#columnValidate').val('');
                $('#columnOptions').val('');
            }

            function updateDynamicColumnCount() {
                updateRowCount('dynamicColumnCount', 'dynamicColumnsTable');
                showHideNoRows('dynamicColumnCount', 'dynamicColumnsTable', 'No dynamic columns found.');
            }

            function setColumnDialogMode(name, mode, type) {
                $('#columnEditDialog #editColumnName').val(name);
                $('#columnEditDialog #editMode').val(mode);
                $('#columnEditDialog #editType').val(type);
                $('#columnEditDialog .modal-header').removeClass('bg-default');
                $('#columnEditDialog .modal-header').removeClass('bg-success');

                // Show / Hide appropriate Input Fields
                if (type == 'static') {
                    $('#columnEditDialog .dynamicColumn').addClass('hidden');
                    $('#columnEditDialog .dynamicColumn').hide();
                    $('#columnEditDialog .staticColumn').removeClass('hidden');
                    $('#columnEditDialog .staticColumn').show();
                }
                else {
                    $('#columnEditDialog .staticColumn').addClass('hidden');
                    $('#columnEditDialog .staticColumn').hide();
                    $('#columnEditDialog .dynamicColumn').removeClass('hidden');
                    $('#columnEditDialog .dynamicColumn').show();
                }

                // Column Name is always Read Only on Edit
                if (mode == 'edit') {
                    $('#columnEditDialog [data-name="name"].dynamicColumn').addClass('hidden');
                    $('#columnEditDialog [data-name="name"].staticColumn').removeClass('hidden');
                    $('#columnEditDialog [data-name="name"].dynamicColumn').hide();
                    $('#columnEditDialog [data-name="name"].staticColumn').show();
                }

                // Show / Hide appropriate Action Buttons
                if (mode == 'add') {
                    $('#columnEditDialog .modal-header').addClass('bg-success');
                    $('#columnEditDialog #columnEditLabel').html('Add Dynamic Column');

                    $('#columnSave').addClass('hidden');
                    $('#columnSave').hide();
                    $('#columnAdd').removeClass('hidden');
                    $('#columnAdd').show();
                }
                else {
                    // Show / Hide appropriate Action Buttons
                    $('#columnAdd').addClass('hidden');
                    $('#columnAdd').hide();
                    $('#columnSave').removeClass('hidden');
                    $('#columnSave').show();

                    // Fix Dialog Header to match Column Type
                    $('#columnEditDialog .modal-header').addClass('bg-default');
                    var dialogHeader = 'Edit Column';
                    if (type == 'static') {
                        dialogHeader = 'Edit Database Column';
                    } else {
                        dialogHeader = 'Edit Dynamic Column';
                    }
                    $('#columnEditDialog #columnEditLabel').html(dialogHeader);
                }
            }

            function buildColumnRow(data) {
                var html = '';

                html += '<tr data-column_name="' + data['name'] + '">' + "\n";
                html += '  <td align="left">' + "\n";
                html += '    <button type="button" class="btn btn-sm btn-default editDynamicColumn" data-column_name="' + data['name'] + '" >Edit</button>' + "\n";
                html += '    <button type="button" class="btn btn-sm btn-danger deleteDynamicColumn" data-column_name="' + data['name'] + '" >Delete</button>' + "\n";
                html += '  </td>' + "\n";
                html += '  <td data-name="name">' + data['name'] + '</td>' + "\n";
                html += '  <td data-name="displayName">' + data['displayName'] + '</td>' + "\n";
                html += '  <td data-name="reportName">' + data['reportName'] + '</td>' + "\n";
                html += '  <td data-name="type">' + data['type'] + '</td>' + "\n";
                html += '  <td data-name="null" data-boolean="1">' + (( data['null'] ) ? 'Yes' : 'No') + '</td>' + "\n";
                html += '  <td data-name="required" data-boolean="1">' + (( data['required'] ) ? 'Yes' : 'No' ) + '</td>' + "\n";
                html += '  <td data-name="sensitive" data-boolean="1">' + (( data['sensitive'] ) ? 'Yes' : 'No' ) + '</td>' + "\n";
                html += '</tr>' + "\n";

                return html;
            }

            function editStaticColumn(element) {
                // Get the Static Column selected
                var name = $(element).attr('data-column_name');

                clearColumnEditDialog();
                setColumnDialogMode(name, 'edit', 'static');

                var params = tableModel.static_columns[name];

                populateEditColumnDialog(params, 'columnEditDialog');

                $('#columnEditDialog').modal('show');
            }

            function editDynamicColumn(element) {
                // Get the Dynamic Column selected
                var name = $(element).attr('data-column_name');

                clearColumnEditDialog();
                setColumnDialogMode(name, 'edit', 'dynamic');

                var params = tableModel.dynamic_columns[name];

                populateEditColumnDialog(params, 'columnEditDialog');

                $('#columnEditDialog').modal('show');
            }

            function updateTableRow(table, showAlerts) {
                var result = true;
                var columnName = $('#columnEditDialog #editColumnName').val();
                var params = tableModel[table][columnName];
                // var data = retrieveEditColumnDialog(params, 'columnEditDialog');
                var data = retrieveEditColumnDialog(formFields, 'columnEditDialog');

                tableModel[table][columnName] = data;

                var $row = $('.' + table + ' tr[data-column_name="' + columnName + '"]');

                for (var name in data) {
                    var value = data[name];
                    var $formField = $row.find('[data-name="' + name + '"]');
                    var rc = setFormField($formField, name, value, showAlerts);

                    if (!rc) {
                        result = false;
                    }
                }

                $('.' + table).DataTable().draw(false);

                return result;
            }

            function saveDynamicColumn(showAlerts) {
                dirtyFlag = true;

                updateDynamicDataTables();

                return updateTableRow('dynamic_columns', showAlerts);
            }

            function saveStaticColumn(showAlerts) {
                dirtyFlag = true;

                updateDbDataTables();

                return updateTableRow('static_columns', showAlerts);
            }

            function addDynamicColumn() {
                dirtyFlag = true;
                var result = true;
                var columnName = $('#columnEditDialog input[data-name="name"]').val();

                if (typeof(tableModel.static_columns[columnName]) != 'undefined') {
                    alert("Duplicate Dynamic Column name = '" + columnName + "'.\nPlease select another name.");
                    return false;
                }

                if (typeof(tableModel.static_columns[columnName]) != 'undefined') {
                    alert("Column name = '" + columnName + "' is a Duplicate of Static column.\nPlease select another name.");
                    return false;
                }

                //for (var firstColumn in tableModel.static_columns) break;
                //var params = tableModel.static_columns[firstColumn];
                // var data = retrieveEditColumnDialog(params, 'columnEditDialog');
                var data = retrieveEditColumnDialog(formFields, 'columnEditDialog');

                data['name'] = columnName;
                if (! tableModel.hasOwnProperty('dynamic_columns') || $.isArray(tableModel['dynamic_columns'])) {
                    tableModel.dynamic_columns = {};
                }
                tableModel.dynamic_columns[columnName] = data;

                var html = buildColumnRow(data);
                var $row = $(html);

                $row.find('.editDynamicColumn').click(function () {
                    editDynamicColumn(this);
                });

                $row.find('.deleteDynamicColumn').click(function () {
                    deleteDynamicColumn(this);
                });

                $('#dynamicColumnsTable').append($row);

                dynamicDataTable.row.add($row);

                updateDynamicColumnCount();
                updateDynamicDataTables();

                $('#columnEditDialog').modal('hide');

                return result;
            }

            function deleteDynamicColumn(element) {
                var $row = $(element).closest('tr');
                var columnName = $row.find('td[data-name="name"]').html();

                var rc = window.confirm("Are you sure you want to delete the Dynamic Column:\nName = '" + columnName + "' ?");
                if (!rc) {
                    return false;
                }

                dirtyFlag = true;

                // Delete from Memory Array
                delete tableModel.dynamic_columns[columnName];

                // Delete from DataTables Copy
                dynamicDataTable.row($row).remove();

                // Delete from DOM Table itself
                $row.remove();

                updateDynamicColumnCount();
                updateDynamicDataTables();
            }

            function saveTable() {
                var data = {};
                data._token = $('[name=_token]').val();
                //data.setting = setting;
                data.tableColumns = tableModel;

                $.ajax({
                    type: 'POST',
                    url: '/admin/settings/tables/api/store',
                    data: data,
                    dataType: 'json',
                    success: function (result) {
                        $(window).off('beforeunload');
                        document.location = '/admin/settings/tables';
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert('Unable to Save Table = ' + tableModel.name + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function updateDbDataTables() {
                dbDataTable.order(dataTableSort).draw();
            }

            function updateDynamicDataTables() {
                dynamicDataTable.order(dataTableSort).draw();
            }

            function syncDbColumns() {
                if (dirtyFlag) {
                    alert("You have modified the Column data.\nEither save your changes, or reload the page before Syncing DB Columns.");
                    return false;
                }

                var data = {};
                data._token = $('[name=_token]').val();
                data.tableId = tableModel.id;
                data.tableKey = tableModel.key;
                data.tableName = tableModel.name;

                $.ajax({
                    type: 'POST',
                    url: '/admin/settings/tables/api/syncdbcolumns',
                    data: data,
                    dataType: 'json',
                    success: function (result) {
                        $(window).off('beforeunload');
                        location.reload();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert('Unable to Sync Table = ' + tableModel.name + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#columnValidateType').change(function () {
                var type = $(this).val();

                if (type == 'custom') {
                    $('#columnEditDialog #customValidate').removeClass('hidden');
                    $('#columnEditDialog #customValidate').show();
                }
                else {
                    $('#columnEditDialog #customValidate').addClass('hidden');
                    $('#columnEditDialog #customValidate').hide();
                }
            });

            $('.editStaticColumn').click(function () {
                editStaticColumn(this);
            });

            $('.editDynamicColumn').click(function () {
                editDynamicColumn(this);
            });

            $('.deleteDynamicColumn').click(function () {
                deleteDynamicColumn(this);
            });

            $('#addDynamicColumn').click(function () {
                clearColumnEditDialog();
                setColumnDialogMode(name, 'add', 'dynamic');
                $('#columnEditDialog').modal('show');
            });

            $('#columnSave').click(function () {
                var type = $('#columnEditDialog #editType').val();
                //var rc;
                var showAlerts = false;

                if (type == 'static') {
                    saveStaticColumn(showAlerts);
                } else {
                    saveDynamicColumn(showAlerts);
                }

                //if (rc) {
                    $('#columnEditDialog').modal('hide');
                //}
            });

            $('#columnAdd').click(function () {
                if (!$("#editColumnForm").valid()) {
                    return false;
                }

                addDynamicColumn();
            });

            $('#cancelTable').click(function () {
                if (dirtyFlag) {
                    var rc = window.confirm("You have unsaved changes.\nAre you sure you want to leave this page?");

                    if (!rc) {
                        return false;
                    }
                }

                if (setting.id == 'new') {
                    document.location = '/admin/settings/tables/create';
                } else {
                    document.location = '/admin/settings/tables/';
                }
            });

            $('#saveTable').click(function () {
                saveTable();
            });

            $('#syncDbColumns').click(function () {
                syncDbColumns();
            });

            $(window).on('beforeunload', function () {
                if (dirtyFlag) {
                    return "You have unsaved changes.\nAre you sure you want to leave this page?";
                }
            });

            $(document).off('show.bs.modal', '#columnEditDialog');

            
            editColumnValidator = $('#editColumnForm').validate();
            dataTableSort = [[0, 'asc']];

            dynamicDataTable = $('#dynamicColumnsTable.has-columns').DataTable({
                columnDefs: [{orderable: false, targets: [6]}],
                pageLength: 100,
                order: dataTableSort
            });

            dbDataTable = $('#dbColumnsTable').DataTable({
                columnDefs: [{orderable: false, targets: [6]}],
                pageLength: 100,
                order: dataTableSort
            });

            updateDynamicColumnCount();

        });
    </script>
@endsection
