<?php

namespace Ignite\Claim\Repositories;

use Ignite\Claim\Entities\Setting;
use Illuminate\Support\Arr;

class SettingsRepository
{
    /** @var array */
    private $cache;

    /**
     * Find all settings.
     *
     * @return array
     */
    public function findAll()
    {
        return $this->fromClassCache();
    }

    /**
     * Find a setting by key.
     *
     * @param  string $key
     * @param  mixed  $default
     * @return mixed
     */
    public function find($key, $default = false)
    {
        return Arr::get($this->fromClassCache(), $key, $default);
    }

    /**
     * Load the settings from the class cache or prime the cache if none exists.
     *
     * @return array
     */
    private function fromClassCache()
    {
        if (! $this->cache) {
            $this->cache = $this->convertToDotNotation($this->fromDatabase());
        }

        return $this->cache;
    }

    /**
     * Retrieve settings from the database.
     *
     * @return array
     */
    private function fromDatabase()
    {
        return optional(Setting::all())->toArray() ?? [];
    }

    /**
     * Set the setting values with dot notation.
     *
     * @param  array $settings
     * @return array
     */
    private function convertToDotNotation(array $settings)
    {
        $cache = [];

        foreach ($settings as $setting) {
            Arr::set($cache, $setting['key'], $setting['value']);
        }

        return $cache;
    }
}
