<?php

namespace Ignite\Claim\Events\Handlers;

use Ignite\Claim\Repositories\ClaimRepository;
use Ignite\Core\Events\EnrollmentSubmitted;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class LinkWaitingClaims
{
    /**
     * @var ClaimRepository
     */
    private $claimRepository;

    /**
     * Create the event listener.
     *
     * @param ClaimRepository $claimRepository
     */
    public function __construct(ClaimRepository $claimRepository)
    {
        $this->claimRepository = $claimRepository;
    }

    /**
     * Handle the event.
     *
     * @param  EnrollmentSubmitted $event
     * @return void
     */
    public function handle(EnrollmentSubmitted $event)
    {
        /** @var \Ignite\Core\Entities\Participant $participant */
        $participant = $event->participant;

        $response = $this->claimRepository->get([
            'class' => 'claim_participant',
            'action' => 'getList',
            'mode' => 'array',
            'participant_email' => $participant->email,
            'user_id' => 'isnull:'
        ]);

        if (! $response->result) {
            return;
        }

        $claimParticipants = $response->data;

        // Link any Waiting Claims for the Participant
        if (empty($claimParticipants)) {
            return;
        }

        foreach ($claimParticipants as $index => $tmpParticipant) {
            $claimParticipant = &$claimParticipants[$index];
            $claimParticipant['class'] = 'claim_participant';
            $claimParticipant['action'] = 'update';
            $claimParticipant['user_id'] = $participant->getKey();
            $claimParticipant['status'] = 'pending';
        }

        try {
            $response = $this->claimRepository->update($claimParticipants);
            if (! $response->result) {
                logger()->error(
                    "Unable to link waiting claims for participant '{$participant->email}' with ID {$participant->getKey()}."
                );
            }
        } catch (\Exception $e) {
            logger()->error(
                "Error while linking waiting claims for participant '{$participant->email}' with ID {$participant->getKey()}."
            );
        }
    }
}
