<div class="container" id="testRulesVue">
    <div class="modal" id="testRulesDialog" tabindex="-1" role="dialog" aria-labelledby="testRulesLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="testRulesLabel">Test Rules for Claim</h4>
                </div>
                <div class="modal-body">
                    <form id="ruleTestForm" class="form-horizontal">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label for="selectClaim" class="col-sm-3 control-label">Claim:</label>
                            <div class="col-sm-9">
                                <select class="form-control" id="selectClaim" v-model="claimId" required>
                                    <option value="">--- Select ---</option>
                                    @foreach($claimsSelect as $claimSelect)
                                        <option value="{{ $claimSelect['id'] }}">{{ $claimSelect['id'] . ' - ' . Format::date($claimSelect['claim_date']) . ' - ' . $claimSelect['first'] . ' ' . $claimSelect['last'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group form-check-inline">
                            <label class="col-sm-3 control-label">Rules Mode:</label>
                            <div class="col-sm-3" id="rulesChecks">
                                <div class="checkbox">
                                    <label>
                                        <input type="radio" name="rulesMode" value="1" @click="setRulesMode(1)" checked> All
                                    </label>
                                    &nbsp; &nbsp; &nbsp;
                                    <label>
                                        <input type="radio" name="rulesMode" value="2" @click="setRulesMode(2)"> Select
                                    </label>
                                    &nbsp; &nbsp; &nbsp;
                                </div>
                            </div>
                            <div class="col-sm-5" :class="{ hidden: hideSelectRules }" id="selectRulesDiv">
                                <button type="button" class="btn btn-sm btn-primary" id="selectRules" data-toggle="modal" data-target="#rulesSelectDialog">Select Rules</button>
                                <textarea class="form-control" id="ruleIdsList" rows="4">@{{ ruleIdsList }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label">Status</label>
                            <div class="col-md-9">
                                <label class="form-check-label margin-top">
                                    <input class="form-check-input" type="checkbox" id="activeOnly" value="1" v-model="activeOnly"> Active Only
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="participantType" class="col-sm-3 control-label">Participant Type</label>
                            <div class="col-md-9">
                                <select class="form-control" id="participantType" v-model="participantType">
                                    <option value="" selected="selected">-- From Claim --</option>
                                    @foreach($participantTypes as $value => $text)
                                    <option value="{{ $value }}">{{ $text }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="rulesTestResult" class="col-sm-3 control-label">Values</label>
                            <div class="col-sm-9">
                                <textarea class="form-control" id="rulesTestResult" rows="5" v-model="rulesTestResult" readonly></textarea>
                            </div>
                        </div>
                        <div class="box box-danger">
                            <div class="box-header with-border">
                                <h3 class="box-title">Details</h3>
                                <div class="col-xs-4 text-right pull-right">
                                    <div class="row">
                                        <label for="debugLevelSelect" class="col-xs-8 text-right">Level:</label>
                                        <select class="col-xs-4 pull-right" size="1" id="debugLevelSelect" v-model="debugLevel">
                                            @foreach(range(0, 10) as $val)
                                                <option value="{{ $val }}">{{ $val }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="box-body no-padding">
                                <textarea class="form-control" id="rulesTestDetails" rows="10" v-model="rulesTestDetails" readonly></textarea>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><span class="text-danger">Cancel</span></button>
                    <button type="button" class="btn btn-primary" id="rulesTest" @click="testRules()">Test</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Rules Select Dialog -->
    <div class="modal " id="rulesSelectDialog" tabindex="-1" role="dialog" aria-labelledby="rulesSelectLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title" id="rulesSelectLabel">Rules to Test</h4>
                </div>
                <div class="modal-body">
                    <form id="rulesForm">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="rulesSelect">Available Rules</label>
                                    <select multiple class="form-control" size="10" name="from[]" id="rulesSelect">
                                        <option  v-for="notSelectedRule in notSelectedRules" :value="notSelectedRule.id">@{{ notSelectedRule.name }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <div class="margin-bottom"><br /><br /></div>
                                    <button type="button" id="rulesSelect_rightAll" class="btn brn-default btn-block"><i class="glyphicon glyphicon-forward"></i></button>
                                    <button type="button" id="rulesSelect_rightSelected" class="btn brn-default btn-block"><i class="glyphicon glyphicon-chevron-right"></i></button>
                                    <button type="button" id="rulesSelect_leftSelected" class="btn brn-default btn-block"><i class="glyphicon glyphicon-chevron-left"></i></button>
                                    <button type="button" id="rulesSelect_leftAll" class="btn brn-default btn-block"><i class="glyphicon glyphicon-backward"></i></button>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="rulesSelect_to">Test Rules</label>
                                    <select multiple class="form-control" size="10" name="to[]" id="rulesSelect_to">
                                        <option v-for="selectedRule in selectedRules" :value="selectedRule.id">@{{ selectedRule.name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" id="rulesClose" data-dismiss="modal"><span class="text-danger">Close</span></button>
                </div>
            </div>
        </div>
    </div>
</div>
