var newCapItem = {
  'id': 'new',
  'offer_promotion_id': '',
  'name': '',
  'description': '',
  'start_date': '',
  'end_date': '',
  'fiscal_month': '1',
  'max_period': '',
  'value_type_id': '1',
  'max_value': '',
  'status': '1'
};

var newPromotionItem = {
  'id': 'new',
  'promotion_group_id': '1',
  'name': '',
  'description': '',
  'start_date': '',
  'end_date': '',
  'status': '1',
  'caps': []
};

new Vue({
  el: '#promotionsVue',
  data: {
    campaignId: $('#campaignId').val(),
    promotions: {},
    promotionId: null,
    promotionAction: '',
    promotion: newPromotionItem,
    capIndex: null,
    capAction: '',
    capItems: [],
    editCapItem: {},
    datePickerOptions: {
      format: 'mm/dd/yyyy',
      autoclose: true,
      pickDate: true
    }
  },

  mounted() {
    var options = {
      format: 'mm/dd/yyyy',
      autoclose: true,
      pickDate: true
    };

    var self = this;

    $('#promotionStartDate').datepicker(options).change(function() {
      self.promotion.start_date = $('#promotionStartDate').val()
    });

    $('#promotionEndDate').datepicker(options).change(function() {
      self.promotion.end_date = $('#promotionEndDate').val()
    });

    $('#capStartDate').datepicker(options).change(function() {
      self.editCapItem.start_date = $('#capStartDate').val()
    });

    $('#capEndDate').datepicker(options).change(function() {
      self.editCapItem.end_date = $('#capEndDate').val()
    });

    $('#capFiscalMonth').datepicker(options).change(function() {
      self.editCapItem.fiscal_month = $('#capFiscalMonth').val()
    });
  },

  methods: {
    renderAmount: function (amount) {
      return window.Ignite.Core.addCommas(amount);
    },
    renderDate: function (dateIn) {
      return (parseInt(dateIn) > 0) ? moment(dateIn).format('M/D/YYYY') : '';
    },
    renderPeriod: function (period) {
      if (typeof maxPeriods[period] != 'undefined')
        return maxPeriods[period];
      else
        return "Unknown Period '" + period + "'";
    },
    updateDatePicker: function (field, picker) {
      field = $(picker).val()
    },
    setCapDialogMode: function (mode) {
      var header = $('#capEditDialog .modal-header');
      header.removeClass('bg-info bg-success bg-danger');

      if (mode === 'add') {
        $('#capEditLabel').html('Add Cap');
        this.capAction = 'add';
        $('#capSave').html('Add');
        $("#capAdd").removeClass('hidden');
      } else if (mode === 'delete') {
        $('#capEditLabel').html('Delete Cap');
        this.capAction = 'delete';
        $('#capSave').html('Delete');
      } else {
        $('#capEditLabel').html('Edit Cap');
        this.capAction = 'update';
        $('#capSave').html('Update');
      }
    },

    validateCapRow: function (mode, capItem) {
      if (capItem.name.trim() === '') {
        alert('Please enter a Name for this Promotion Cap.');
        return false;
      }

      if (!capItem.max_value || isNaN(capItem.max_value)) {
        alert('Please enter a Number for Max Value.');
        return false;
      }

      return true;
    },

    addCap: function () {
      if (!this.validateCapRow('add', this.editCapItem)) {
        return false;
      }

      this.promotion.caps[this.promotion.caps.length] = this.editCapItem;
      this.editCapItem = $.extend(true, {}, newCapItem);
      $("#capEditDialog").modal('hide');
    },

    deleteCap: function (capItem) {
      var index = this.promotion.caps.indexOf(capItem);
      this.promotion.caps.splice(index, 1);
    },

    editCap: function (capItem) {
      this.capIndex = this.promotion.caps.indexOf(capItem);
      this.editCapItem = $.extend(true, {}, capItem);

      this.setCapDialogMode('edit');
      $("#capEditDialog").modal('show');
    },

    newCap: function () {
      this.editCapItem = $.extend(true, {}, newCapItem);
      this.setCapDialogMode('add');
      $("#capEditDialog").modal('show');
    },

    saveCap: function (capItem) {
      switch (this.capAction) {
        case 'add':
          this.addCap(capItem);
          break;
        case 'delete':
          this.deleteCap(capItem);
          break;
        case 'update':
          this.updateCap(capItem);
          break;
      }
    },

    updateCap: function (capItem) {
      if (!this.validateCapRow('edit', this.editCapItem))
        return false;

      this.promotion.caps[this.capIndex] = this.editCapItem;
      this.editCapItem = $.extend(true, {}, newCapItem);
      $("#capEditDialog").modal('hide');
    },

    setPromotionDialogMode: function (mode) {
      if (mode === 'add') {
        this.promotionAction = 'new';
        $('#promotionEditLabel').html('Create Promotion');
        $('#promotionSave').html('Create');
      } else if (mode === 'delete') {
        this.promotionAction = 'delete';
        $('#promotionEditLabel').html('Delete Promotion');
        $('#promotionSave').html('Delete');
      } else {
        this.promotionAction = 'update';
        $('#promotionEditLabel').html('Edit Promotion');
        $('#promotionSave').html('Update');
      }
    },

    newPromotion: function () {
      this.promotion = $.extend(true, {}, newPromotionItem);
      this.promotion.offer_promotion_id = $('#promotionId').val();
      $('[name="editPromotionGroupId"][value="' + this.promotion.promotion_group_id + '"]').trigger('change');

      this.setPromotionDialogMode('add');
      $("#promotionEditDialog").modal('show');
    },

    getPromotion: function (id) {
      var self = this;
      var promotionId = id;

      axios.get('/offer/api/promotion/get/' + id)
        .then(function (response) {
          self.promotion = response.data.data;
          self.promotion.start_date = self.renderDate(self.promotion.start_date);
          self.promotion.end_date = self.renderDate(self.promotion.end_date);
          $('[name="editPromotionGroupId"][value="' + self.promotion.promotion_group_id + '"]').trigger('change');
          // $('.datepicker').each(function() {
          //     $(this).datepicker('update');
          // });
        })
        .catch(function (response) {
          var messages = getResponseErrors(response, 'response.data.messages');
          alert('Unable to Get Promotion for Id = ' + promotionId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
        });
    },

    editPromotion: function (id) {
      this.getPromotion(id);
      this.setPromotionDialogMode('edit');
      $("#promotionEditDialog").modal('show');
    },

    savePromotion: function () {
      var self = this;
      var token = $('[name=_token]').val();
      var action = $('#promotionAction').val();

      var data = $.extend(true, {}, this.promotion);
      data._token = token;
      data.campaign_id = self.campaignId;

      if (action == 'delete') {
        var id = self.promotion.id;
        axios.post('/offer/api/promotion/delete', {'promotion_id': id, '_token': token})
          .then(function (response) {
            self.promotion = $.extend(true, {}, newPromotionItem);
            $("#promotionEditDialog").modal('hide');
            location.reload();
          })
          .catch(function (response) {
            var messages = getResponseErrors(response, 'response.data.messages');
            alert('Unable to Delete Promotion for Id = ' + data.id + "\n" + messages + response.response.status + ': ' + response.response.statusText);
          });
      } else {
        axios.post('/offer/api/promotion/store', data)
          .then(function (response) {
            self.promotion = $.extend(true, {}, newPromotionItem);
            $("#promotionEditDialog").modal('hide');
            location.reload();
          })
          .catch(function (response) {
            var messages = getResponseErrors(response, 'response.data.messages');
            if (data.id == 'new')
              alert('Unable to Create New Promotion' + "\n" + messages + response.response.status + ': ' + response.response.statusText);
            else
              alert('Unable to Save Promotion for Id = ' + data.id + "\n" + messages + response.response.status + ': ' + response.response.statusText);
          });
      }
    },

    deletePromotion: function (id) {
      this.getPromotion(id);
      this.setPromotionDialogMode('delete');
      $("#promotionEditDialog").modal('show');
    }
  }
});
