<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;

class Table extends Model
{
    /** @var string */
    protected $table = 'claim_table';

    /** @var string */
    protected $primaryKey  = 'id';

    /** @var array */
    protected $casts = [
        'static_columns' => 'json',
        'dynamic_columns' => 'json',
    ];

    /** @var null|\Illuminate\Database\Eloquent\Collection */
    protected static $cache;

    /**
     * Find a table record by key.
     *
     * @param  string $key
     * @return \Ignite\Claim\Entities\Table
     */
    public static function findByKey($key)
    {
        if (is_null(static::$cache)) {
            static::$cache = static::all()->keyBy('key');
        }

        return static::$cache->get($key, null);
    }

    /**
     * Merge the static and dynamic columns into one list.
     *
     * @return array
     */
    public function getMergedColumns()
    {
        $columns = [];

        foreach ($this->static_columns as $name => $params) {
            $columns[$name] = $params;
        }

        if (! empty($this->dynamic_columns)) {
            foreach ($this->dynamic_columns as $name => $params) {
                $columns[$name] = $params;
            }
        }

        return $columns;
    }
}
