@extends('Claim::admin.rules.layouts.master')

@section('page_heading', 'Edit Rule: ' . $rule['name'])
@section('page_breadcrumb', 'Edit Rule: ' . $rule['name'])

@section('page_content')

<form id="ruleForm" class="form-horizontal" method="post" action="/admin/rule/store">
    <input type="hidden" id="mode" name="mode" value="{{ $mode }}" />
    <input type="hidden" id="code" name="code" value="{{ $code }}" />
    <input type="hidden" id="offer_promotion_id" name="offer_promotion_id" value="{{ $rule['offer_promotion_id'] }}" />
    <input type="hidden" id="id" name="id" value="{{ $rule['id'] }}" />

    {{ csrf_field() }}

    <div class="row form-affix-container">
        <div class="col-sm-8 form-affix-body">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Promotion Details</h3>
                </div>
                <div class="box-body">
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Promotion:</label>
                        <div class="col-sm-8">
                            <input type="text" readonly class="form-control" value="{{ $promotion['name'] }}"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Active:</label>
                        <div class="col-sm-8">
                            <input type="text" readonly class="form-control" value="{{ (( $promotion['status'] ) ? 'Y' : 'N') }}"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Start Date:</label>
                        <div class="col-sm-8">
                            <input type="text" readonly class="form-control" value="{{ Format::datetime($promotion['start_date'], 'm/d/Y') }}"/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">End Date:</label>
                        <div class="col-sm-8">
                            <input type="text" readonly class="form-control" value="{{ Format::datetime($promotion['end_date'], 'm/d/Y') }}"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Rule Settings</h3>
                </div>
                <div class="box-body">
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="name">Rule Name:</label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" id="name" name="name" value="{{ $rule['name'] }}" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="name">Order:</label>
                        <div class="col-sm-1" style="min-width: 75px;">
                            <input type="text" class="form-control" id="order" name="order" value="{{ $rule['order'] }}" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="start_date">Start Date:</label>
                        <div class="col-sm-4">
                            <input placeholder="Click to show calendar" type="text" class="form-control datepicker" id="start_date" name="start_date" value="{{ Format::datetime($rule['start_date'], 'm/d/Y') }}" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="end_date">End Date:</label>
                        <div class="col-sm-4">
                            <input placeholder="Click to show calendar" type="text" class="form-control datepicker" id="end_date" name="end_date" value="{{ Format::datetime($rule['end_date'], 'm/d/Y') }}" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="status">Status:</label>
                        <div class="col-sm-8">
                            <label style="margin-top: 7px">
                                <input type="checkbox" id="status" name="status" value="1" @if( $rule['status'] )checked="checked"@endif> Active
                            </label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="max_times" class="col-sm-3 control-label">Max / Claim</label>
                        <div class="col-sm-4">
                            <select class="form-control" id="max_times" name="max_times">
                                <option value="0" @if ($rule['max_times'] == "0")selected="selected"@endif>-- No Limit --</option>
                                @foreach(range(1, 10) as $val)
                                <option value="{{ $val }}" @if ($val == $rule['max_times'])selected="selected"@endif>{{ $val }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="participants_mode_id">Participants Mode:</label>
                        <div class="col-sm-3">
                            <div class="input-group">
                                <div class="checkbox">
                                @foreach($participantsModeOptions as $value => $text)
                                    <label>
                                        <input type="radio" name="participants_mode_id" value="{{ $value }}" @if( $rule['participants_mode_id'] == $value )checked="checked"@endif> {{ $text }}
                                    </label>
                                @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3 hidden" id="selectParticipantsDiv">
                            <button type="button" class="btn btn-sm btn-primary btn-block" id="selectParticipants">Select Participants</button>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="offers_mode_id">Offers Mode:</label>
                        <div class="col-sm-3">
                            <div class="checkbox">
                              @foreach($offersModeOptions as $value => $text)
                                <label>
                                    <input type="radio" name="offers_mode_id" value="{{ $value }}" @if( $rule['offers_mode_id'] == $value )checked="checked"@endif> {{ $text }}
                                </label>
                              @endforeach
                            </div>
                        </div>
                        <div class="col-sm-3 hidden" id="selectOffersDiv">
                            <button type="button" class="btn btn-sm btn-primary btn-block" id="selectOffers">Select Offers</button>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-md-3 control-label" for="value_mode_id">Value Source:</label>
                        <div class="col-md-4">
                            <select class="form-control" id="value_mode_id" name="value_mode_id" required>
                                <option value="" @if ($rule['value_mode_id'] == "")selected="selected"@endif>-- Select --</option>
                              @foreach($valueSourceOptions as $value => $name)
                                <option value="{{ $value }}" @if ($value == $rule['value_mode_id'])selected="selected"@endif>{{ $name }}</option>
                              @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="form-group hidden no-margin" id="singleValueDiv">
                        <div class="box box-default">
                            <div class="box-header with-border">
                                <strong>Single Value</strong>
                            </div>
                            <div class="box-body no-padding">
                                <div class="form-group">
                                    <label class="col-sm-3 control-label" for="value">Value Type:</label>
                                    <div class="col-sm-4" style="padding-top: 10px">
                                        <select class="form-control" id="value_type_id" name="value_type_id">
                                        @foreach($valueTypeOptions as $value => $text)
                                            <option value="{{ $value }}" @if ($value == $rule['value_type_id'])selected="selected"@endif>{{ $text }}</option>
                                        @endforeach
                                        </select>
                                      </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-3 control-label" for="value">Value:</label>
                                    <div class="col-sm-4" style="padding-top: 10px">
                                        <input type="text" class="form-control" id="value" name="value" value="{{ $rule['value'] }}" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group hidden no-margin" id="multipleValuesDiv">
                        <div class="box box-default">
                            <div class="box-header with-border">
                                <button type="button" class="btn btn-sm btn-primary pull-right" id="newValue" data-id="new">New Value</button>
                                <strong>Values by Participant</strong>
                            </div>
                            <div class="box-body">
                                <table class="table" id="valuesList">
                                    <thead class="thead-default">
                                        <tr>
                                            <th>Participant</th>
                                            <th>Value Type</th>
                                            <th>Value</th>
                                            <th class="text-right">&nbsp;</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($rule['values'] as $value)
                                        <tr class="bg-white" data-id="{{ $value['id'] }}" data-index="{{ $loop->index  }}">
                                            <td data-participant_type="{{ $value['participant_type'] }}">{{ $participantTypes[$value['participant_type']] }}</td>
                                            <td data-value_type_id="{{ $value['value_type_id'] }}">{{ $valueTypeOptions[$value['value_type_id']] }}</td>
                                            <td data-value="{{ $value['value'] }}">{{ $value['value'] }}</td>
                                            <td class="text-right text-nowrap">
                                                <a type="button" class="btn btn-sm btn-default valueEdit" data-id="{{ $value['id'] }}">Edit</a>
                                                <a type="button" class="btn btn-sm btn-danger valueDelete" data-id="{{ $value['id'] }}">Delete</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr class="noRows">
                                            <td colspan="10" class="bg-warning">No participant values defined.</td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Conditions</h3>
                    <button type="button" class="btn btn-sm btn-primary pull-right" id="newCondition">New Condition</button>
                </div>
                <div class="box-body">
                    <table class="table" id="conditionsList">
                        <thead class="thead-default">
                            <tr>
                                <th>DB Column</th>
                                <th>Directive</th>
                                <th>Data 1</th>
                                <th>Data 2</th>
                                <th class="text-right">&nbsp;</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($rule['conditions'] as $condition)
                            <tr class="bg-white" data-id="{{ $condition['id'] }}" data-index="{{ $loop->index  }}">
                                <td data-db_column="{{ $condition['db_column'] }}">{{ $dbColumns[$condition['db_column']]['name'] }}</td>
                                <td data-directive="{{ $condition['directive'] }}">{{ $directiveOptions[$condition['directive']] }}</td>
                                <td data-data_1="">{{ $condition['data_1'] }}</td>
                                <td data-data_2="">{{ $condition['data_2'] }}</td>
                                <td class="text-right text-nowrap">
                                    <a type="button" class="btn btn-sm btn-default conditionEdit" data-toggle="modal" data-id="{{ $condition['id'] }}">Edit</a>
                                    <a type="button" class="btn btn-sm btn-danger conditionDelete" data-toggle="modal" data-id="{{ $condition['id'] }}">Delete</a>
                                </td>
                            </tr>
                        @empty
                            <tr class="noRows">
                                <td colspan="10" class="text-center text-danger">No rule conditions defined.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-4 pull-right form-affix-actions">
            <div class="box box-primary">
                <div class="box-footer">
                    <a type="button" class="btn btn-default pull-left" href="{{ url('/admin/rule/rules') . '/' . $rule['offer_promotion_id'] }}" id="backButton">Back</a>
                    <input type="submit" class="btn btn-primary pull-right" id="saveRule" value="Save">
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Offers Show/Select Dialog -->
<div class="modal" id="offersSelectDialog" tabindex="-1" role="dialog" aria-labelledby="offersSelectLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title text-primary" id="offersSelectLabel">Offers for Rule</h4>
            </div>
            <div class="modal-body">
                <form id="offersForm">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="offersSelect">Available Offers</label>
                                <select multiple class="form-control" size="10" name="from[]" id="offersSelect">
                                @foreach($notHasOffers as $id => $offer)
                                    <option value="{{ $offer['offer_id'] }}" data-id="new">{{ $offer['name'] }}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <div class="margin-bottom"><br/><br/></div>
                                <button type="button" id="offersSelect_rightAll" class="btn btn-default btn-block"><i class="glyphicon glyphicon-forward"></i></button>
                                <button type="button" id="offersSelect_rightSelected" class="btn btn-default btn-block"><i class="glyphicon glyphicon-chevron-right"></i></button>
                                <button type="button" id="offersSelect_leftSelected" class="btn btn-default btn-block"><i class="glyphicon glyphicon-chevron-left"></i></button>
                                <button type="button" id="offersSelect_leftAll" class="btn btn-default btn-block"><i class="glyphicon glyphicon-backward"></i></button>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="offersSelect_to">Rule Has Offers</label>
                                <select multiple class="form-control" size="10" name="to[]" id="offersSelect_to">
                                @foreach($hasOffers as $id => $offer)
                                    <option value="{{ $offer['offer_id'] }}" data-id="{{ $offer['id'] }}">{{ $offer['name'] }}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" id="offersClose"><span class="text-danger">Close</span></button>
            </div>
        </div>
    </div>
</div>

<!-- Participants Show/Select Dialog -->
<div class="modal" id="participantsSelectDialog" tabindex="-1" role="dialog" aria-labelledby="participantsSelectLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title text-primary" id="participantsSelectLabel">Participants for Rule</h4>
            </div>
            <div class="modal-body">
                <form id="participantsForm">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="participantsSelect">Available Participants</label>
                                <select multiple class="form-control" size="10" name="from[]" id="participantsSelect">
                                @foreach($notHasParticipants as $name => $participant)
                                    <option value="{{ $participant['participant_type'] }}" data-id="new">{{ $participant['participant_type'] }}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <div class="margin-bottom"><br/><br/></div>
                                <button type="button" id="participantsSelect_rightAll" class="btn btn-block"><i class="glyphicon glyphicon-forward"></i></button>
                                <button type="button" id="participantsSelect_rightSelected" class="btn btn-block"><i class="glyphicon glyphicon-chevron-right"></i></button>
                                <button type="button" id="participantsSelect_leftSelected" class="btn btn-block"><i class="glyphicon glyphicon-chevron-left"></i></button>
                                <button type="button" id="participantsSelect_leftAll" class="btn btn-block"><i class="glyphicon glyphicon-backward"></i></button>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="participantsSelect_to">Rule Has Participants</label>
                                <select multiple class="form-control" size="10" name="to[]" id="participantsSelect_to">
                                @foreach($hasParticipants as $name => $participant)
                                    <option value="{{ $participant['participant_type'] }}" data-id="{{ $participant['id'] }}">{{ $participant['participant_type'] }}</option>
                                @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" id="participantsClose"><span class="text-danger">Close</span></button>
            </div>
        </div>
    </div>
</div>

<!-- Value Dialog -->
<div class="modal" id="valueEditDialog" tabindex="-1" role="dialog" aria-labelledby="valueEditLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title text-primary" id="valueEditLabel">Maintain Value</h4>
            </div>
            <div class="modal-body">
                <form id="valueForm">
                    <input type="hidden" id="valueIndex" />
                    <input type="hidden" id="valueId" />
                    <div class="form-group">
                        <label for="valueName">Type</label>
                        <select class="form-control" id="valueName">
                            <option value="">-- Select --</option>
                            @foreach($participantTypes as $value => $text)
                            <option value="{{ $value }}">{{ $text }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="valueType">Mode</label>
                        <select class="form-control" id="valueType">
                        @foreach($valueTypeOptions as $value => $text)
                            <option value="{{ $value }}">{{ $text }}</option>
                        @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="valueValue">Value</label>
                        <input class="form-control" id="valueValue">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><span class="text-danger">Cancel</span></button>
                <button type="button" class="btn btn-primary hidden" id="valueAdd">Add</button>
                <button type="button" class="btn btn-danger hidden" id="valueDelete">Delete</button>
                <button type="button" class="btn btn-primary hidden" id="valueSave">Save</button>
            </div>
        </div>
    </div>
</div>

<!-- Condition Dialog -->
<div class="modal " id="conditionEditDialog" tabindex="-1" role="dialog" aria-labelledby="conditionEditLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title text-primary" id="conditionEditLabel">Maintain Condition</h4>
            </div>
            <div class="modal-body">
                <form id="conditionForm">
                    <input type="hidden" id="conditionIndex" />
                    <input type="hidden" id="conditionId" />

                    <div class="form-group">
                        <label for="offerName">DB Column</label>
                        <select class="form-control" id="conditionDbColumn">
                            <option value="">-- Select --</option>
                            @foreach($dbColumns as $value => $column)
                            <option value="{{ $value }}">{{ $column['name'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="conditionDirective">Directive</label>
                        <select class="form-control" id="conditionDirective">
                            <option value="">-- Select --</option>
                            @foreach($directiveOptions as $value => $text)
                            <option value="{{ $value }}">{{ $text }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="conditionData1">Data 1</label>
                        <textarea class="form-control" id="conditionData1"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="conditionData2">Data 2</label>
                        <textarea class="form-control" id="conditionData2"></textarea>
                    </div>
                    <!--
                    <div class="form-group">
                        <label for="conditionOrder">Order</label>
                        <input class="form-control" id="conditionOrder">
                    </div>
                    -->
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><span class="text-danger">Cancel</span></button>
                <button type="button" class="btn btn-primary hidden" id="conditionAdd">Add</button>
                <button type="button" class="btn btn-danger hidden" id="conditionDelete">Delete</button>
                <button type="button" class="btn btn-primary hidden" id="conditionSave">Save</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
@parent
<script>
var dirtyFlag = false;
var participantTypes = {!! json_encode($participantTypes, JSON_PRETTY_PRINT) !!} ;
var offersLookup = {!! json_encode($offersLookup, JSON_PRETTY_PRINT) !!} ;

$(document).ready(function() {

    window.validationConfig = {
        errorElement: 'em',
        errorPlacement: function (error, element) {
            error.addClass('help-block');
            element.parents('.form-group').addClass('has-feedback');

            if (element.prop('type') === 'checkbox') {
                error.insertAfter(element.parent('label'));
            } else {
                error.insertAfter(element);
            }
            /*if (! element.parent().next('span')[0]) {
                $("<span class='fa fa-remove form-control-feedback'></span>").appendTo(element.parents('.form-group'));
            }*/
        },
        success: function (label, element) {
            /*var $element = $(element);
            if (! $element.parent().next('span')[0]) {
                $("<span class='fa fa-check text-success form-control-feedback'></span>").appendTo($element.parents('.form-group'));
            }*/
        },
        highlight: function (element, errorClass, validClass) {
            var $element = $(element);
            $element.parents('.form-group').addClass('has-error').removeClass('has-success');
        },
        unhighlight: function (element, errorClass, validClass) {
            var $element = $(element);
            $element.parents('.form-group').removeClass('has-success').removeClass('has-error');
        }
    };

    $('#campaignId').change(function() {
        var campaignId = $('#campaignId').val();
        var url = '/rule/list/' + campaignId;
        window.location.replace(url);
    });

    function addNoRows(table, message)
    {
        var count = $('#' + table + ' tbody tr').length;

        if ( count != 0 )
            return false;

        var html = '';
        html += '<tr class="noRows">' + "\n";
        html += '  <td colspan="10" class="bg-warning">' + message + '</td>' + "\n";
        html += '</tr>' + "\n";

        $('#' + table + ' tbody').append(html);

        return true;
    }

    // ----------------------------------------------
    // Participant Value functions
    // ----------------------------------------------
    function clearParticipantValueDialog()
    {
        $('#valueIndex').val('');
        $('#valueId').val('new');

        $('#valueName').val('');
        $('#valueType').val('1');
        $('#valueValue').val('');
    }

    function setValueDialogMode(mode)
    {
        $('#valueEditDialog #editMode').val(mode);

        //$('#valueEditDialog .modal-header').removeClass('bg-default');
        //$('#valueEditDialog .modal-header').removeClass('bg-success');
        $('#valueEditDialog .modal-header').removeClass('bg-danger');

        // Hide all Action Buttons
        $('#valueEditDialog #valueAdd').addClass('hidden');
        $('#valueEditDialog #valueSave').addClass('hidden');
        $('#valueEditDialog #valueDelete').addClass('hidden');

        // Show appropriate Action Buttons
        switch(mode)
        {
            case 'add':
                //$('#valueEditDialog .modal-header').addClass('bg-success');
                $('#valueEditDialog #valueEditLabel').html('Add Participant Value');
                $('#valueAdd').removeClass('hidden');
                break;

            case 'delete':
                $('#valueEditDialog .modal-header').addClass('bg-danger');
                $('#valueEditDialog #valueEditLabel').html('Delete Participant Value');

                $('#valueDelete').removeClass('hidden');
                break;

            default:
                //$('#valueEditDialog .modal-header').addClass('bg-default');
                $('#valueEditDialog #valueEditLabel').html('Edit Participant Value');
                $('#valueSave').removeClass('hidden');
                break;
        }
    }

    function buildParticipantValueRow(count)
    {
        var id = $('#valueId').val();
        var type = $('#valueName').val();
        var typeText = $('#valueName').find('option:selected').text();
        var mode = $('#valueType').val();
        var modeText = $('#valueType').find('option:selected').text();
        var value = $('#valueValue').val();
        var html = '<tr class="valueItem" data-id="' + id + '" data-index="' + count + '">' + "\n";

        html += '  <td data-participant_type="' + type + '">' + typeText + "</td>\n";
        html += '  <td data-value_type_id="' + mode + '">' + modeText + "</td>\n";
        html += '  <td data-value="' + value + '">' + value + "</td>\n";

        var editButton   = '    <button type="button" class="btn btn-sm btn-default valueEdit">Edit</button>' + "\n";
        var deleteButton = '    <button type="button" class="btn btn-sm btn-danger valueDelete">Delete</button>' + "\n";

        html += '  <td class="text-right text-nowrap">' + "\n" + editButton + deleteButton + "  </td>\n";
        html += '</tr>' + "\n";

        var $row = $(html);

        $row.find('.valueEdit').click(function(){ editParticipantValueRow(this); });
        $row.find('.valueDelete').click(function(){ deleteParticipantValueRow(this); });

        return $row;
    }

    function populateParticipantValueDialog(element)
    {
        clearParticipantValueDialog();

        var $row = $(element).closest('tr');

        var index = $row.attr('data-index');
        var id = $row.attr('data-id');

        var typeText = $row.find('td[data-participant_type]').html();
        var type = '';
        $('#valueName option').each(function() {
            if ( $(this).text() == typeText ) {
            	type = $(this).val();
            }
        });

        var modeText = $row.find('td[data-value_type_id]').html();
        var mode = '';
        $('#valueType option').each(function() {
            if ( $(this).text() == modeText ) {
            	mode = $(this).val();
            }
        });

        var value = $row.find('td[data-value]').html().trim();

        $('#valueId').val(id);
        $('#valueIndex').val(index);

        $('#valueName').val(type);
        $('#valueType').val(mode);
        $('#valueValue').val(value);
    }

    function validateParticipantValueRow(mode)
    {
        var type = $('#valueName').val();
        var value = $('#valueValue').val().trim();

        if ( type == '' ) {
            alert('Please select a Participant Type.');
            return false;
        }

        if ( value === '' || isNaN(value) ) {
            alert('Please enter a Number for Value.');
            return false;
        }

        var index = $('#valueIndex').val();
        var typeUsed = false;
        $('#valuesList tbody [data-participant_type]').each(function() {
            if ( $(this).attr('data-participant_type') == type ) {
                var rowIndex = $(this).closest('tr').attr('data-index');
                if ( mode == 'add' || rowIndex != index)
                    typeUsed = true;
            }
        });

        if ( typeUsed ) {
            alert("Participant Type already in Values list.\nPlease select a different Participant Type.");
            return false;
        }

        return true;
    }

    function addParticipantValueRow()
    {
        $('#valueIndex').val('');

        if ( ! validateParticipantValueRow('add') )
            return false;

        dirtyFlag = true;

        $('#valuesList tbody tr.noRows').remove();

        var count = $('#valuesList tbody tr').length + 1;
        var $row = buildParticipantValueRow(count);

        $('#valuesList tbody').append($row);

        $('#valueEditDialog').modal('hide');
    }

    function editParticipantValueRow(element)
    {
        setValueDialogMode('edit');
        populateParticipantValueDialog(element);
        $('#valueEditDialog').modal('show');
    }

    function deleteParticipantValueRow(element)
    {
        dirtyFlag = true;

        $(element).closest('tr').remove();

        addNoRows('valuesList', 'No Participant Values Defined.');
    }

    function updateParticipantValueRow()
    {
        dirtyFlag = true;

        if ( ! validateParticipantValueRow('edit') )
            return false;

        var index = $('#valueIndex').val();
        var $row = buildParticipantValueRow(index);

        var $participantValueRow = $('#valuesList tbody tr[data-index="' + index + '"]');

        $participantValueRow.replaceWith($row);

        $('#valueEditDialog').modal('hide');
    }

    // ----------------------------------------------
    // Rule Condition functions
    // ----------------------------------------------
    function clearConditionDialog()
    {
        $('#conditionIndex').val('');
        $('#conditionId').val('new');
        $('#conditionDbColumn').val('');
        $('#conditionDirective').val('');
        $('#conditionData1').val('');
        $('#conditionData2').val('');

        var count = $('#conditionsList tbody tr[data-id]').length + 1;

        $('#conditionOrder').val(count);
    }

    function setConditionDialogMode(mode)
    {
        $('#conditionEditDialog #editMode').val(mode);
        $('#conditionEditDialog .modal-header').removeClass('bg-default');
        $('#conditionEditDialog .modal-header').removeClass('bg-success');
        $('#conditionEditDialog .modal-header').removeClass('bg-danger');
        // Hide all Action Buttons
        $('#conditionEditDialog #conditionAdd').addClass('hidden');
        $('#conditionEditDialog #conditionSave').addClass('hidden');
        $('#conditionEditDialog #conditionDelete').addClass('hidden');

        // Show appropriate Action Buttons
        switch(mode) {
            case 'add':
                $('#conditionEditDialog .modal-header').addClass('bg-success');
                $('#conditionEditDialog #conditionEditLabel').html('Add Condition');
                $('#conditionAdd').removeClass('hidden');
                break;

            case 'delete':
                $('#conditionEditDialog .modal-header').addClass('bg-danger');
                $('#conditionEditDialog #conditionEditLabel').html('Delete Condition');
                $('#conditionDelete').removeClass('hidden');
                break;

            default:
                $('#conditionEditDialog .modal-header').addClass('bg-default');
                $('#conditionEditDialog #conditionEditLabel').html('Edit Condition');
                $('#conditionSave').removeClass('hidden');
                break;
        }
    }

    function buildConditionRow(count)
    {
        var id = $('#conditionId').val();
        var column = $('#conditionDbColumn').val();
        var columnText = $('#conditionDbColumn').find('option:selected').text();
        var directive = $('#conditionDirective').val();
        var directiveText = $('#conditionDirective').find('option:selected').text();
        var data1 = $('#conditionData1').val().trim();
        var data2 = $('#conditionData2').val().trim();
        // var order = $('#conditionOrder').val().trim();
        var html = '<tr class="conditionItem" data-id="' + id + '" data-index="' + count + '">' + "\n";
        html += '  <td data-db_column="' + column + '">' + columnText + "</td>\n";
        html += '  <td data-directive="' + directive + '">' + directiveText + "</td>\n";
        html += '  <td data-data_1>' + data1 + "</td>\n";
        html += '  <td data-data_2>' + data2 + "</td>\n";
        // html += '  <td data-order="' + order + '">' + order + "</td>\n";
        var editButton   = '    <button type="button" class="btn btn-sm btn-default conditionEdit">Edit</button>' + "\n";
        var deleteButton = '    <button type="button" class="btn btn-sm btn-danger conditionDelete">Delete</button>' + "\n";

        html += '  <td class="text-right text-nowrap">' + "\n" + editButton + deleteButton + "  </td>\n";
        html += '</tr>' + "\n";

        var $row = $(html);
        $row.find('.conditionEdit').click(function(){ editConditionRow(this); });
        $row.find('.conditionDelete').click(function(){ deleteConditionRow(this); });

        return $row;
    }

    function populateConditionDialog(element)
    {
        clearConditionDialog();
        var $row = $(element).closest('tr');
        var index = $row.attr('data-index');
        var id = $row.attr('data-id');
        var columnText = $row.find('td[data-db_column]').html();
        var column = '';
        $('#conditionDbColumn option').each(function() {
            if ( $(this).text() == columnText ) {
                column = $(this).val();
            }
        });

        var directiveText = $row.find('td[data-directive]').html();
        var directive = '';
        $('#conditionDirective option').each(function() {
            if ( $(this).text() == directiveText ) {
                directive = $(this).val();
            }
        });

        var data1 = $row.find('td[data-data_1]').html().trim();
        var data2 = $row.find('td[data-data_2]').html().trim();
        // var order = $row.find('td[data-order]').html().trim();

        $('#conditionIndex').val(index);
        $('#conditionId').val(id);
        $('#conditionDbColumn').val(column);
        $('#conditionDirective').val(directive);
        $('#conditionData1').val(data1);
        $('#conditionData2').val(data2);
        // $('#conditionOrder').val(order);
    }

    function validateConditionRow()
    {
        var column = $('#conditionDbColumn').val();
        var directive = $('#conditionDirective').val();
        var data1 = $('#conditionData1').val().trim();
        var data2 = $('#conditionData1').val().trim();

        if ( column == '' ) {
            alert('Please select a DB Column.');
            return false;
        }

        if (directive == '') {
            alert('Please select a Directive.');
            return false;
        }

        if (data1 == '') {
            alert('Please a value for Data 1.');
            return false;
        }

        return true;
    }

    function addConditionRow()
    {
        $('#conditionIndex').val('');
        if (! validateConditionRow()) {
            return false;
        }
        dirtyFlag = true;
        $('#conditionsList tbody tr.noRows').remove();
        var count = $('#conditionsList tbody tr').length + 1;
        var $row = buildConditionRow(count);
        $('#conditionsList tbody').append($row);
        $('#conditionEditDialog').modal('hide');
    }

    function editConditionRow(element)
    {
        setConditionDialogMode('edit');
        populateConditionDialog(element);
        $('#conditionEditDialog').modal('show');
    }

    function updateConditionRow()
    {
        dirtyFlag = true;
        if (! validateConditionRow()) {
            return false;
        }

        var index = $('#conditionIndex').val();
        var $row = buildConditionRow(index);
        var $conditionRow = $('#conditionsList tbody tr[data-index="' + index + '"]');
        $conditionRow.replaceWith($row);

        $('#conditionEditDialog').modal('hide');
    }

    function deleteConditionRow(element)
    {
        dirtyFlag = true;
        $(element).closest('tr').remove();
        addNoRows('conditionsList', 'No Rule Conditions Defined.');
    }

    $('#value_mode_id').change(function() {
        var valueSource = $('#value_mode_id').val();

        $('#multipleValuesDiv').addClass('hidden');
        $('#singleValueDiv').addClass('hidden');

        if (valueSource == 3 || valueSource == 5) {
            $('#multipleValuesDiv').removeClass('hidden');
        }
        else if (valueSource == 2 || valueSource == 4) {
            $('#singleValueDiv').removeClass('hidden');
        }
    });

    $('[name=offers_mode_id]').change(function() {
        var offersModeId = $('[name=offers_mode_id]:checked').val();
        if ( offersModeId == '1' ) {
            $('#selectOffersDiv').addClass('hidden');
        }
        else {
            $('#selectOffersDiv').removeClass('hidden');
        }
    });

    $('[name=participants_mode_id]').change(function() {
        var participantsModeId = $('[name=participants_mode_id]:checked').val();
        if ( participantsModeId == '1' ) {
            $('#selectParticipantsDiv').addClass('hidden');
        }
        else {
            $('#selectParticipantsDiv').removeClass('hidden');
        }
    });

    function saveRule()
    {
        var data = {};
        var promotionId         = $('#offer_promotion_id').val();
        var offersModeId        = $('[name=offers_mode_id]:checked').val();
        var participantsModeId  = $('[name=participants_mode_id]:checked').val();
        var html = '';

        // Get the Participants
        var participants = [];
        if (participantsModeId != '1') {
            $('#participantsSelect_to').find('option').each(function(idx) {
                // var participant = {};
                // participant.name = $(this).text();
                // participants[count] = participant;
                html  = '<input type="hidden" name="participants[' + idx + '][id]" value="' + $(this).attr('data-id') + '" />' + "\n";
                html += '<input type="hidden" name="participants[' + idx + '][participant_type]" value="' + $(this).text() + '" />' + "\n";
                $('#ruleForm').append(html);
                //++count;
            });
        }

        // Get the Offers
        var offers = [];
        var count = 0;
        if ( offersModeId != '1' ) {
            $('#offersSelect_to option').each(function() {
                // var offer = {};
                // offer.id = $(this).val();
                // offer.name = $(this).text();
                // offers[count] = offer;
                offer = offersLookup[$(this).val()];
                html  = '<input type="hidden" name="offers[' + count + '][id]" value="' + $(this).attr('data-id') + '" />' + "\n";
                html += '<input type="hidden" name="offers[' + count + '][offer_id]" value="' + offer.id + '" />' + "\n";
                html += '<input type="hidden" name="offers[' + count + '][name]" value="' + offer.name + '" />' + "\n";
                html += '<input type="hidden" name="offers[' + count + '][sku]" value="' + offer.sku + '" />' + "\n";
                html += '<input type="hidden" name="offers[' + count + '][offer_group]" value="' + offer.offer_group + '" />' + "\n";
                $('#ruleForm').append(html);
                ++count;
            });
        }

        // Get the Participant Values
        var values = [];
        var valueModeId = $('#value_mode_id').val();
        if ( valueModeId != '1' ) {
            $('#valuesList tbody tr[data-id]').each(function(idx) {
                // var value = {};
                // value.id = $(this).attr('data-id');
                // value.type = $(this).find('td[data-participant_type]').attr('data-participant_type');
                // value.mode = $(this).find('td[data-value_type_id]').attr('data-value_type_id');
                // value.value = $(this).find('td[data-value]').attr('data-value');
                // values[count] = value;
                html  = '<input type="hidden" name="values[' + idx + '][id]" value="' + $(this).attr('data-id') + '" />' + "\n";
                html += '<input type="hidden" name="values[' + idx + '][participant_type]" value="' + $(this).find('td[data-participant_type]').attr('data-participant_type') + '" />' + "\n";
                html += '<input type="hidden" name="values[' + idx + '][value_type_id]" value="' + $(this).find('td[data-value_type_id]').attr('data-value_type_id') + '" />' + "\n";
                html += '<input type="hidden" name="values[' + idx + '][value]" value="' + $(this).find('td[data-value]').attr('data-value') + '" />' + "\n";
                $('#ruleForm').append(html);
            });
        }

        // Get the Conditions
        var conditions = [];
        var count = 0;
        $('#conditionsList tbody tr[data-id]').each(function() {
            // var condition = {};
            // condition.id = $(this).attr('data-id');
            // condition.db_column = $(this).find('td[data-db_column]').attr('data-db_column');
            // condition.directive = $(this).find('td[data-directive]').attr('data-directive');
            // condition.data_1 = $(this).find('td[data-data_1]').html();
            // condition.data_2 = $(this).find('td[data-data_2]').html();
            // condition.order = $(this).find('td[data-order]').attr('data-order');
            // conditions[count] = condition;
            html  = '<input type="hidden" name="conditions[' + count + '][id]" value="' + $(this).attr('data-id') + '" />' + "\n";
            html += '<input type="hidden" name="conditions[' + count + '][db_column]" value="' + $(this).find('td[data-db_column]').attr('data-db_column') + '" />' + "\n";
            html += '<input type="hidden" name="conditions[' + count + '][directive]" value="' + $(this).find('td[data-directive]').attr('data-directive') + '" />' + "\n";
            html += '<input type="hidden" name="conditions[' + count + '][data_1]" value="' + $(this).find('td[data-data_1]').html() + '" />' + "\n";
            html += '<input type="hidden" name="conditions[' + count + '][data_2]" value="' + $(this).find('td[data-data_2]').html() + '" />' + "\n";
            // html += '<input type="hidden" name="conditions[' + count + '][order]" value="' + $(this).find('td[data-order]').attr('data-order') + '" />' + "\n";
            $('#ruleForm').append(html);
            ++count;
        });

        // Turn Off Safety check for Modified Data
        $(window).off('beforeunload');

        $('#ruleForm').trigger('submit');
/*
        data._token = $('[name=_token]').val();
        data.mode                 = $('#mode').val();
        data.id                   = $('#id').val();
        data.name                 = $('#name').val();
        data.start_date           = $('#start_date').val();
        data.end_date             = $('#end_date').val();
        data.status               = ( $('#status').prop('checked') ) ? 1 : 0;
        data.offer_promotion_id   = $('#offer_promotion_id').val();
        data.value_mode_id        = $('#value_mode_id').val();
        data.offers_mode_id       = offersModeId;
        data.participants_mode_id = participantsModeId;

        data.participants       = participants;
        data.values             = values;
        data.offers             = offers;
        data.conditions         = conditions;

        $.ajax({
            type: 'POST',
            url: '/admin/rule/store',
            data: data,
            dataType: 'json',
            success: function(result){
                $(window).off('beforeunload');
                document.location = '/admin/rule/rules/' . promotionId;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert("Unable to Save Rule.\n" + xhr.status + ': ' + thrownError);
            }
        });
*/
    }

    // ------------------------
    // Value Button Handlers
    // ------------------------
    $('#newValue').click(function() {
        setValueDialogMode('add');
        clearParticipantValueDialog();
        $('#valueEditDialog').modal('show');
    });

    $('#valueSave').click(function() {
        updateParticipantValueRow();
    });

    $('#valueAdd').click(function() {
        addParticipantValueRow();
    });

    $('.valueEdit').click(function() {
        editParticipantValueRow(this);
    });

    $('.valueDelete').click(function() {
        deleteParticipantValueRow(this);
    });

    // ------------------------
    // Condition Button Handlers
    // ------------------------
    $('#newCondition').click(function() {
        setConditionDialogMode('add');
        clearConditionDialog();
        $('#conditionEditDialog').modal('show');
    });

    $('#conditionSave').click(function() {
        updateConditionRow();
    });

    $('#conditionAdd').click(function() {
        addConditionRow();
    });

    $('.conditionEdit').click(function() {
        editConditionRow(this);
    });

    $('.conditionDelete').click(function() {
        deleteConditionRow(this);
    });

    // ------------------------
    // Left-Right Selector Handlers
    // ------------------------
    $('#selectOffers').click(function() {
        $('#offersSelectDialog').modal('show');
    });

    $('#offersClose').click(function() {
        $('#offersSelectDialog').modal('hide');
    });

    $('#selectParticipants').click(function() {
        $('#participantsSelectDialog').modal('show');
    });

    $('#participantsClose').click(function() {
        $('#participantsSelectDialog').modal('hide');
    });

    $('#offersSelect').multiselect();
    $('#participantsSelect').multiselect();

    // ------------------------
    // Page Level Handlers
    // ------------------------
    $('#saveRule').click(function(e) {
        e.preventDefault();
        //$(this).attr('disabled', 'disabled');
        saveRule();
    });

    $('.datepicker').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true
    }).on('show.bs.modal', function(event) {
        // Prevent datepicker from firing bootstrap modal "show.bs.modal"
        event.stopPropagation();
    });

    $(window).on('beforeunload', function() {
        if ( dirtyFlag ) {
            return "You have unsaved changes.\nAre you sure you want to leave this page?";
        }
    });

    $('[name=offers_mode_id]').trigger('change');
    $('[name=participants_mode_id]').trigger('change');
    $('#value_mode_id').trigger('change');

    var ruleFormValidator = $('#ruleForm').validate(window.validationConfig);
    //var claimItemValidator = $('#addClaimItemForm').validate();
});
</script>

@endsection
