@extends('Claim::layouts.settings')

@section('page_heading', 'Settings')

@section('page_breadcrumb', 'All')

@section('page_content')

    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li class="active"><a href="{{ url('/admin/settings/settings') }}">Settings</a></li>
            <li><a href="{{ url('/admin/settings/forms') }}">Forms</a></li>
            <li><a href="{{ url('/admin/settings/tables') }}">Tables</a></li>
        </ul>
        <div class="tab-content" style="overflow-x: scroll">

            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#settingEditDialog" data-setting_id="new"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
            <table class="table table-striped table-responsive table-data" id="settingsTable">
                <thead>
                    <tr>
                        <th>Actions</th>
                        <th>#</th>
                        <th>Key</th>
                    </tr>
                </thead>
                <tbody>
                @forelse($settings as $setting)
                    <tr>
                        <td width="100" nowrap class="text-right text-nowrap">
                            <button type="button" class="btn btn-sm btn-default" data-toggle="modal"
                                    data-target="#settingEditDialog" data-setting_id="{{ $setting['id'] }}">
                                Edit
                            </button>
                            <button type="button" class="btn btn-sm btn-danger" data-toggle="modal"
                                    data-target="#settingEditDialog" data-setting_id="{{ $setting['id'] }}"
                                    data-setting_action="delete">
                                Delete
                            </button>
                        </td>
                        <td>{{ $setting['id'] }}</td>
                        <td>{{ $setting['key'] }}</td>
                        <td>{{ $setting['value'] }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="10" class="text-danger text-center">No settings defined.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal" id="settingEditDialog" tabindex="-1" role="dialog" aria-labelledby="settingEditLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title" id="settingEditLabel">Manage Setting</h3>
                </div>
                <div class="modal-body">
                    <form>
                        {{ csrf_field() }}
                        <input type="hidden" id="settingId" value="">
                        <input type="hidden" id="settingAction" value="">

                        <div class="form-group">
                            <label for="settingKey">Key</label>
                            <input class="form-control" id="settingKey">
                        </div>

                        <div class="form-group">
                            <label for="settingValue">Value</label>
                            <textarea class="form-control" id="settingValue" rows="3"></textarea>
                        </div>

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="settingSave">Save</button>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-success" id="bgSuccess" style="display: none;"></div>
    <div class="bg-danger" id="bgDanger" style="display: none;"></div>
    <input type="text" id="bgDisabled" style="display: none;" disabled/>

@endsection

@push('js')
    <script>
        $(document).ready(function () {

            function clearSettingDialog() {
                $('#settingEnvironment').val('');
                $('#settingKey').val('');
                $('#settingValue').val('');
            }

            function populateSettingDialog(settingId) {
                $.ajax({
                    type: 'GET',
                    url: '/admin/settings/api/get/' + settingId,
                    dataType: 'json',
                    success: function (result) {
                        var setting = result.data;
                        //$('#settingEnvironment').val(setting.environment);
                        $('#settingKey').val(setting.key);
                        $('#settingValue').val(setting.value);
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        var messages = ( typeof(xhr.responseJSON.messages) != 'undefined' ) ? xhr.responseJSON.messages.join("\n") : '';
                        alert('Unable to Get Setting for id = ' + settingId + "\n" + messages + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function saveSetting() {
                var settingId = $('#settingId').val();
                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#settingId').val();
                //data.environment = $('#settingEnvironment').val();
                data.key = $('#settingKey').val();
                data.value = $('#settingValue').val();

                $.ajax({
                    type: 'POST',
                    url: '/admin/settings/api/store',
                    data: data,
                    dataType: 'json',
                    success: function (result) {
                        var setting = result.data;
                        $("#settingEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        var messages = ( typeof(xhr.responseJSON.messages) != 'undefined' ) ? xhr.responseJSON.messages.join("\n") : '';
                        alert('Unable to Update Setting id = ' + settingId + "\n" + messages + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            function deleteSetting() {
                var data = {};
                data._token = $('[name=_token]').val();
                data.id = $('#settingId').val();

                $.ajax({
                    type: 'POST',
                    url: '/admin/settings/api/delete',
                    data: data,
                    dataType: 'json',
                    success: function (result) {
                        var setting = result.data;
                        $("#settingEditDialog").modal('hide');
                        location.reload();
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        var messages = ( typeof(xhr.responseJSON.messages) != 'undefined' ) ? xhr.responseJSON.messages.join("\n") : '';
                        alert('Unable to Delete Setting id = ' + settingId + "\n" + messages + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#settingEditDialog').on('show.bs.modal', function (event) {
                // Button that triggered the modal
                var button = $(event.relatedTarget);
                // Extract action from data-* attributes
                var action = button.data('setting_action');
                var settingId = button.data('setting_id');

                $('#settingId').val(settingId);
                $('#settingEditDialog .modal-header').removeClass('bg-info');
                $('#settingEditDialog .modal-header').removeClass('bg-success');
                $('#settingEditDialog .modal-header').removeClass('bg-danger');

                if (action == 'delete') {
                    $('#settingEditLabel').html('Delete Setting');
                    $('#settingAction').val('delete');
                    $('#settingSave').html('Delete');
                    $('#settingEditDialog .modal-header').addClass('bg-danger');
                    populateSettingDialog(settingId);
                }
                else {
                    if (settingId == 'new') {
                        $('#settingEditLabel').html('Add New Setting');
                        $('#settingAction').val('new');
                        $('#settingSave').html('Create');
                        $('#settingEditDialog .modal-header').addClass('bg-success');
                        clearSettingDialog(settingId);
                    } else {
                        $('#settingEditLabel').html('Edit Setting');
                        $('#settingAction').val('update');
                        $('#settingSave').html('Update');
                        $('#settingEditDialog .modal-header').addClass('bg-default');
                        populateSettingDialog(settingId);
                    }
                }
            });

            $('#settingSave').click(function (event) {
                var action = $('#settingAction').val();
                if (action == 'delete') {
                    deleteSetting();
                } else {
                    saveSetting();
                }
            });

            $('#settingsTable').DataTable({
                columnDefs: [{orderable: false, targets: [2]}],
                'order': [[0, 'asc'], [1, 'asc']]
            });
        });
    </script>
@endpush
