@php
    $claimId = $formData['claim_id'] ?? $formData['id'];
    $claimParticipantId = isset($claimParticipantId) ? $claimParticipantId : isset($formData['claim_participant']['id']) ? $formData['claim_participant']['id'] : '';
@endphp
@if (! in_array(Route::current()->getName(), ['admin.claim.create', 'admin.claim.edit', 'admin.claim.review']))
    <a class="btn btn-block btn-primary margin-bottom" href="{{ route('admin.claim.edit', [$claimId, $claimParticipantId]) }}">
        <span class="fa fa-edit"></span>
        <span>Edit Claim</span>
    </a>
@endif
<div class="box box-solid form-affix">
    <div class="box-body no-padding">
        <ul class="nav nav-pills nav-stacked">
            @if (isset($formData['user_id']))
                <li>
                    <a href="{{ route('admin.claim.show', [$claimId, $claimParticipantId]) }}">
                        <span class="fa fa-gift"></span>
                        <span>Claim Info</span>
                    </a>
                </li>
            @endif
            @if (! in_array(Route::current()->getName(), ['admin.claim.create', 'admin.claim.edit', 'admin.claim.review']))
            <li>
                <a href="/admin/claim/testapprove/{{ $claimId }}/{{ $claimParticipantId }}">
                    <span class="fa fa-flask text-warning"></span>
                    <span class="text-warning">Test Approve</span>
                </a>
            </li>
            @endif
            @if (isset($formData['user_id']) && ! in_array($formData['claim_participant']['status'], ['approved', 'issued']))
                <li>
                    <a onclick="return confirm('Are you sure you want to delete this claim participant record?')" href="{{ route('admin.claim.destroy', $claimId, $formData['user_id']) }}">
                        <span class="fa fa-trash text-danger"></span>
                        <span class="text-danger">Delete Claim Participant</span>
                    </a>
                </li>
            @endif
            <li>
                <a href="{{ route('admin.claim.list', ['status' => session('claimListType')]) }}">
                    <span class="fa fa-chevron-left"></span> Back to List
                </a>
            </li>
        </ul>
    </div>
</div>
