<?php

namespace Ignite\Claim\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use Ignite\Claim\Entities\Rule;
use Ignite\Claim\Entities\RuleCalculate;

class RuleAdminApiController extends Controller
{
	/**
	 * RuleAdminApiController constructor.
	 */
    public function __construct()
    {
        $this->middleware(['auth']);
    }
	/**
	 * Test the rule.
	 *
	 * @return \Illuminate\Contracts\Routing\ResponseFactory|\Symfony\Component\HttpFoundation\Response
	 */
    public function testRule()
    {
        $formData = request()->all();

        $response = new \stdClass;
        $response->result   = true;
        $response->messages = [];
        $response->data     = false;

        try {
            $params = [];
            $params['claimId']      = $formData['claimId'];
            $params['activeOnly']   = $formData['activeOnly'];
            $params['ruleIds']      = $formData['ruleIds'];

            $params['participantType']  = ( isset($formData['participantType']) )     ? $formData['participantType']    : '';

            $params['debugMode']        = ( isset($formData['debugMode']) )     ? $formData['debugMode']    : 0;
            $params['debugLevel']       = ( isset($formData['debugLevel']) )    ? $formData['debugLevel']   : 10;
            $params['detailLevel']      = ( isset($formData['detailLevel']) )   ? $formData['detailLevel']  : 10;

            $ruleCalc = app(RuleCalculate::class);

            $response = $ruleCalc->value($params);
        }
        catch (\Exception $e) {
            $response->result   = false;
            $response->messages[] = $e->getMessage();
        }

        $httpCode = ($response->result) ? 200 : 422;

        return response(json_encode($response), $httpCode);
    }
}
