<?php

namespace Ignite\Claim\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\AdminMenuPreCompile;

class AddClaimMenu
{
    /**
     * Handle the event.
     *
     * @param AdminMenuPreCompile $event
     */
    public function handle(AdminMenuPreCompile $event)
    {
        $event->getManager()->merge(
            $event->getManager()->hydrateItems(
                $this->getItems()
            )
        );
    }

    /**
     * The menu items in their raw format.
     *
     * @return \Illuminate\Support\Collection
     */
    private function getItems()
    {
        return collect([
            [
                'position' => 50,
                'url' => '/admin/claim',
                'label' => 'Claims',
                'icon' => 'gift',
                'allow' => auth()->user()->can('claim.browse'),
                'children' => [
                    [
                        'position' => 1,
                        'url' => route('admin.claim.create'),
                        'label' => 'Create Claim',
                        'icon' => 'plus',
                        'allow' => auth()->user()->can('claim.create'),
                    ],
                    [
                        'position' => 2,
                        'url' => route('admin.claim.process'),
                        'label' => 'Process Claims',
                        'icon' => 'check',
                        'allow' => auth()->user()->can('claim.process.view'),
                    ],
                    [
                        'position' => 3,
                        'url' => route('admin.claim.issue'),
                        'label' => 'Issue Claims',
                        'icon' => 'dollar',
                        'allow' => auth()->user()->can('claim.issued.view'),
                    ],
                    [
                        'position' => 4,
                        'url' => route('admin.claim.trashed'),
                        'label' => 'Trashed',
                        'icon' => 'trash',
                        'allow' => auth()->user()->can('claim.trashed.browse'),
                    ],
                    [
                        'position' => 5,
                        'url' => route('admin.claim.list', ['type' => 'all']),
                        'label' => 'All',
                        'icon' => "circle-o text-gray",
                        'allow' => auth()->user()->can('claim.all.browse'),
                    ],
                    [
                        'position' => 6,
                        'url' => route('admin.claim.list', ['type' => 'pending']),
                        'label' => 'Pending',
                        'icon' => "circle-o text-yellow",
                        'allow' => auth()->user()->can('claim.pending.browse'),
                    ],
                    [
                        'position' => 7,
                        'url' => route('admin.claim.list', ['type' => 'approved']),
                        'label' => 'Approved',
                        'icon' => "circle-o text-green",
                        'allow' => auth()->user()->can('claim.approved.browse'),
                    ],
                    [
                        'position' => 8,
                        'url' => route('admin.claim.list', ['type' => 'issued']),
                        'label' => 'Issued',
                        'icon' => "circle-o text-aqua",
                        'allow' => auth()->user()->can('claim.issued.browse'),
                    ],
                    [
                        'position' => 9,
                        'url' => route('admin.claim.list', ['type' => 'declined']),
                        'label' => 'Declined',
                        'icon' => "circle-o text-danger",
                        'allow' => auth()->user()->can('claim.declined.browse'),
                    ],
                    [
                        'position' => 10,
                        'url' => route('admin.claim.list', ['type' => 'cancelled']),
                        'label' => 'Cancelled',
                        'icon' => "circle-o text-red",
                        'allow' => auth()->user()->can('claim.cancelled.browse'),
                    ],
                    [
                        'position' => 20,
                        'url' => '/admin/claim/offers',
                        'label' => 'Offers',
                        'icon' => 'dollar',
                        'allow' => auth()->user()->can('claim.offer.browse'),
                        'children' => [
                            [
                                'position' => 1,
                                'url' => route('admin.offer.promotiongroups.index'),
                                'label' => 'Promotion Groups',
                                'icon'  => 'bullseye',
                                'allow' => auth()->user()->can('claim.offer.promotions.group.browse'),
                            ],
                            [
                                'position' => 2,
                                'url' => route('admin.offer.show'),
                                'label' => 'Promotions',
                                'icon' => 'bullhorn',
                                'allow' => auth()->user()->can('claim.offer.promotion.browse'),
                            ],
                            [
                                'position' => 3,
                                'url' => route('admin.offer.index'),
                                'label' => 'Offers',
                                'icon' => 'tag',
                                'allow' => auth()->user()->can('claim.offer.browse'),
                            ],
                            [
                                'position' => 4,
                                'url'   => route('admin.offer.userpromotiongroups'),
                                'label'  => 'User Promotion Groups',
                                'icon'  => 'random',
                                'allow' => auth()->user()->can('claim.offer.user.promotion.group.browse'),
                            ],
                        ],
                    ],
                    [
                        'position'	=> 45,
                        'url' => '/admin/claim/rules',
                        'label' => 'Rules',
                        'icon' => 'check-square-o',
                        'allow' => auth()->user()->can('claim.rule.browse'),
                        'children' => [
                            [
                                'position' => 1,
                                'url'   => route('admin.rule.promotions.index'),
                                'label'  => 'Promotions',
                                'icon'  => 'bullhorn',
                                'allow' => auth()->user()->can('claim.rule.promotion.browse'),
                            ],
                        ],
                    ],
                    [
                        'position' => 50,
                        'url' => '/admin/claim/configuration',
                        'label' => 'Configuration',
                        'icon' => 'wrench',
                        'allow' => auth()->user()->can('claim.configuration.browse'),
                        'children' => [
                            [
                                'position' => 1,
                                'url' => route('admin.settings.index'),
                                'label' => 'Settings',
                                'icon' => 'cog',
                                'allow' => auth()->user()->can('claim.configuration.settings.browse'),
                            ],
                            [
                                'position' => 2,
                                'url' => route('admin.settings.forms'),
                                'label' => 'Forms',
                                'icon' => 'object-group',
                                'allow' => auth()->user()->can('claim.configuration.form.browse'),
                            ],
                            [
                                'position' => 3,
                                'url' => route('admin.settings.tables'),
                                'label' => 'Tables',
                                'icon' => 'database',
                                'allow' => auth()->user()->can('claim.configuration.table.browse'),
                            ],
                        ],
                    ]
                ],
            ]
        ]);
    }
}
