<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimOfferPromotionTable extends Migration
{
    protected $tableName = 'claim_offer_promotion';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('campaign_id');
            $table->unsignedInteger('promotion_group_id');
            $table->string('name', 100);
            $table->string('description', 500)->nullable();
            $table->text('html')->nullable();
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
            $table->unique('name');
            $table->foreign('campaign_id', 'op_campaign_foreign')->references('id')->on('claim_offer_campaign');
            $table->foreign('promotion_group_id', 'op_promotion_group_foreign')->references('id')->on('claim_offer_promotion_group');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
