<?php

namespace Ignite\Claim\Http\Views;

use Ignite\Claim\Models\Summary\Metric;
use Illuminate\Support\Collection;
use Illuminate\View\View;

class ClaimSummaryComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('summary', $summary = $this->decorate($this->query()->map(function ($metric) {
            return app(Metric::class, (array) $metric);
        })->keyBy(function ($metric) {
            return $metric->name();
        })));

        $view->with('summaryTotal', $summary->sum(function ($metric) {
            return (int) $metric->count();
        }));
    }

    /**
     * Query the metrics from the database.
     *
     * @return Collection
     */
    protected function query()
    {
        return app('db')->table('claim_participant')
            ->selectRaw('status as name, COUNT(*) AS count, SUM(value) as total')
            ->where('user_id', auth()->user()->getKey())
            ->groupBy('status')
            ->get();
    }

    /**
     * Decorate the summary collection.
     *
     * @param  Collection $collection
     * @return Collection
     */
    protected function decorate(Collection $collection)
    {
        $allowedStatuses = ['approved', 'pending', 'declined', 'issued'];

        foreach ($allowedStatuses as $allowedStatus) {
            if (! $collection->has($allowedStatus)) {
                $collection->push(app(Metric::class, [
                    'name' => $allowedStatus,
                    'count' => 0,
                    'total' => 0
                ]));
            }
        };

        return $collection->keyBy(function ($metric) {
            return $metric->name();
        });
    }
}