<form id="claimForm" class="form-classic" method="post" action="{{ $claimReviewUri }}">
    <input type="hidden" id="code" name="code" value="{{ $code }}" />
    <input type="hidden" id="filesCode" name="filesCode" value="{{ $filesCode ?? '' }}" />
    <input type="hidden" id="mode" name="mode" value="{{ $mode }}" />
    <input type="hidden" id="offer_promotion_id" name="offer_promotion_id" value="{{ $formData['offer_promotion_id'] }}" />
    <input type="hidden" id="claim_id" name="claim_id" value="{{ $formData['claim_id'] }}" />
    <input type="hidden" id="created_at" name="created_at" value="{{ $formData['created_at'] }}" />
    <input type="hidden" id="maxParticipants" name="maxParticipants" value="{{ $formData['maxParticipants'] ?? '' }}" />
    <input type="hidden" id="maxLineitems" name="maxLineitems" value="{{ $formData['maxLineitems'] ?? '' }}" />
    {{ csrf_field() }}
    <div class="panel panel-default">
        @if(! empty($isAdminLayout))
            <div class="panel-heading">
                <div class="panel-title">
                    <h4 class="no-padding no-margin">{{ __('Core::core.fields.external') }}</h4>
                </div>
            </div>
        @else
            <div class="panel-heading">
                <div class="panel-title">
                    <h4 style="margin: 0; padding-top: 5px;" class="align-middle">{{ __('Claim::claim.form_heading') }}</h4>
                </div>
            </div>
        @endif
        <div class="panel-body">
            @include('Claim::partials.claimFieldsExternal')

            @if (setting('claim.use_simplified_lineitems'))
                @include('Claim::partials.claimItemsSimplified_static')
            @endif
        </div>
    </div>

    @if(! empty($isAdminLayout) && $mode != 'new')
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="row form-inline">
                    <div class="col-md-6">
                        <h4 class="no-margin" style="padding-top: 5px;">{{ __('Claim::claim.participants.heading') }}</h4>
                    </div>
                    <div class="col-md-6 input-group pull-right" style="padding-right: 15px !important;">
                        <label class="input-group-addon">{{ __('Core::core.participant.singular') }}</label>
                        <select class="form-control select2" name="claimParticipantSelect" id="claimParticipantSelect">
                            @foreach($participantOptions as $id => $name)
                                <option value="{{ $id }}"{{ ($id == $formData['claim_participant']['id']) ? ' selected="selected"' : '' }}>
                                    {{ $name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="panel-body">
                <input type="hidden" name="dynamicFields[claim_participant][id]" value="{{ $formData['claim_participant']['id'] }}" />
                @include('Claim::partials.claimFieldsInternal')
            </div>
        </div>
    @endif

    @if($mode == 'new')
        @if ($formData['maxParticipants'] > 0)
            @include('Claim::partials.claimParticipantList_static')
        @endif
    @endif

    @if (! setting('claim.use_simplified_lineitems'))
        @include('Claim::partials.claimItemsList_static')
    @endif

    @if(! empty($documentTypes) )
        @include('Claim::partials.claimFiles')
    @endif

    @if(! empty($isAdminLayout))
        <div class="box-footer">
            @if ($mode == 'new')
                <a class="btn btn-default pull-left" href="/admin/claim/promotions"><span class="text-danger">{{ __('Core::core.buttons.cancel') }}</span></a>
            @else
                <a class="btn btn-default pull-left" href="/admin/claim/list/{{ $listType }}"><span class="text-danger">{{ __('Core::core.buttons.cancel') }}</span></a>
            @endif

            <button class="btn btn-primary pull-right" type="submit" id="review">{{ __('Core::core.buttons.review') }}</button>
        </div>
    @else
        <div class="clearfix">
            <a class="btn btn-xs btn-danger offset-top-0 pull-left" href="/claim/promotions">{{ __('Core::core.buttons.cancel') }}</a>
            <button type="submit" class="btn btn-xs btn-info offset-top-0 pull-right" id="review">{{ __('Core::core.buttons.review') }}</button>
        </div>
    @endif
</form>
