@extends('Claim::layouts.master')

@section('tab_content')
    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
    <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h3>Delete Claim</h3>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Claim?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-danger btn-ok">Delete</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
                    action: function (e) {
                        e.preventDefault();
                        window.location.href = '{{ route('admin.claim.create') }}'
                    }
                }]
            });

            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this claim participant?',
                request: { method: 'GET', type: 'json' },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $dataTable.DataTable().ajax.reload();
                        });
                }
            });
        });
    </script>
@endsection
