<div class="claim-additional-participant-panel">
    @include('claim.partials.participants_instructions')
    <div class="panel{{ !empty($isAdminLayout) ? ' panel-default' : '' }}">
        <div class="panel-heading">
            <div class="panel-title row">
                <div class="col-md-6">
                    <strong style="margin: 0; padding-top: 5px;" class="align-middle">{{ __('Claim::claim.participants.heading') }}</strong>
                    <span class="badge badge-success" id="claimParticipantCount">{{ count($formData['claim_participants']) }}</span>
                </div>
                <div class="col-md-3 text-right pull-right">
                    <button type="button" class="btn btn-sm btn-success align-middle" id="addClaimParticipant" data-claim_participant_id="new">{{ __('Claim::claim.participants.actions.add') }}</button>
                </div>
            </div>
        </div>
        <div class="panel-body pre-scrollable">
            <table class="table" id="claimParticipantsList">
                <thead>
                    <tr class="claimItemsHeader">
                        <th>#</th>
                        <th>{{ __('Claim::claim.participants.email') }}</th>
                        <th>{{ __('Claim::claim.participants.type') }}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($formData['claim_participants'] as $index => $claimParticipant)
                    <tr class="claimParticipant">
                        <td name="lineNumber">{{ $loop->iteration }}</td>
                        <td>
                            <input type="hidden" name="id" value="{{ (( ! empty($claimParticipant['id']) ) ? $claimParticipant['id'] : 'new') }}"/>
                            <input type="hidden" name="participant_email" value="{{ $claimParticipant['participant_email'] }}"/>{{ $claimParticipant['participant_email'] }}
                        </td>
                        <td>
                            <input type="hidden" name="participant_type" value="{{ $claimParticipant['participant_type'] }}"/>{{ $claimParticipant['participant_type'] }}
                        </td>
                        <td class="text-right text-nowrap">
                            <button type="button" class="btn btn-sm btn-default editClaimParticipant">
                                <span class="text-info"><span class="fa fa-pencil"></span> {{ __('Claim::claim.participants.actions.edit') }}</span>
                            </button>
                            <button type="button" class="btn btn-sm btn-default deleteClaimParticipant">
                                <span class="text-danger"><span class="fa fa-trash"></span> {{ __('Claim::claim.participants.actions.delete') }}</span>
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
