@extends('Claim::admin.offers.layouts.master')

@section('page_heading', 'Promotions')
@section('page_breadcrumb', 'Promotions')

@section('tab_before')
<div id="promotionsVue">
@endsection

@section('tab_buttons')
@endsection

@section('tab_content')

    <div class="row">
        <div class="col-xs-4">
            <button type="button" class="btn btn-default" @click.prevent="newPromotion()" data-promotion_id="new"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
        </div>
        <div class="col-xs-8">
        @if (count($campaigns) > 1)
            <div class="input-group">
                <label for="campaignId" class="input-group-addon">Campaign:&nbsp;</label>
                <select class="form-control" id="campaignId" name="campaignId" v-model="campaignId">
                    @foreach($campaigns as $campaign)
                        <option value="{{ $campaign['id'] }}" @if ($campaign['id'] == "$campaignId")selected="selected"@endif>{{ $campaign['name'] }}</option>
                    @endforeach
                </select>
            </div>
        @elseif (count($campaigns) == 1)
            @php ($campaign = reset($campaigns))
            <div class="input-group">
                <input type="hidden" id="campaignId" name="campaignId" value="{{ $campaign['id'] }}" v-model="campaignId"/>
            </div>
        @else
            <div class="input-group">
                <input type="hidden" id="campaignId" name="campaignId" value="1" v-model="campaignId"/>
            </div>
        @endif
        </div>
        {{--
        @if ( count($promotionGroups) > 0 )
          <div class="col-md-6 controlsDiv">
            <label for="promotionGroupId" class="control-label">Promotion Group:&nbsp;</label>
            <select class="form-control" size="1" name="promotionGroupId" id="promotionGroupId" v-model="promotionGroupId">
              @foreach($promotionGroups as $promotionGroup)
                <option value="{{ $promotionGroup['id'] }}" @if ($promotionGroup['id'] == "$promotionGroupId")selected="selected"@endif>{{ $promotionGroup['name'] }}</option>
              @endforeach
            </select>
          </div>
        @else
            <div class="input-group">
                <input type="hidden" id="promotionGroupId" name="promotionGroupId" value="1" v-model="promotionGroupId"/>
            </div>
        @endif
        --}}
    </div>
    <hr />
    <table class="table table-bordered table-striped table-responsive table-data">
        <thead class="thead-default">
            <tr>
                <th>&nbsp;</th>
                <th>#</th>
                <th>Name</th>
                <th>Descripton</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
        @forelse($promotions as $promotion)
            <tr class="bg-white" data-promotion_id="{{ $promotion['id'] }}">
                <td nowrap width="{{ (empty($promotion['has_offers']) && $promotion['id'] > 1) ? '120' : '60' }}">
                    <button type="button" class="btn btn-sm btn-default" @click.prevent="editPromotion({{ $promotion['id'] }})" data-promotion_action="edit" >
                        Edit
                    </button>
                    @if (empty($promotion['has_offers']) && $promotion['id'] > 1)
                        <button type="button" class="btn btn-sm btn-danger" @click.prevent="deletePromotion({{ $promotion['id'] }})" data-promotion_action="delete" >
                            Delete
                        </button>
                    @endif
                </td>
                <td class="offerDetails">{{ $promotion['id'] }}</td>
                <td class="offerDetails">{{ $promotion['name'] }}</td>
                <td class="offerDetails" title="Click for Offers Details.">{{ $promotion['description'] }}</td>
                <td class="offerDetails">{{ Format::date($promotion['start_date']) }}</td>
                <td class="offerDetails">{{ Format::date($promotion['end_date']) }}</td>
                <td class="offerDetails">{{ ($promotion['status'] == 1) ? 'Active' : 'Inactive' }}</td>
            </tr>
            <tr class="offerRow" data-promotion_id="{{ $promotion['id'] }}">
                <td colspan="10">
                    <table class="table">
                        @if (count($promotion['offers']) > 0 )
                            <tr class="table-info bg-info">
                                <th style="width:20px;">&nbsp;</th>
                                <th>#</th>
                                <th>Name</th>
                                <th>SKU</th>
                                <th>Description</th>
                            </tr>
                            @foreach($promotion['offers'] as $offer)
                                <tr class="offerDetails">
                                    <td style="width:20px;">&nbsp;</td>
                                    <td>{{ $offer['id'] }}</td>
                                    <td>{{ $offer['name'] }}</td>
                                    <td>{{ $offer['sku'] }}</td>
                                    <td>{{ $offer['description'] }}</td>
                                </tr>
                            @endforeach <!-- promotion->permissions -->
                        @else
                            <tr class="offerDetails">
                                <td colspan="10" class="text-center text-danger">No offers defined.</td>
                            </tr>
                    @endif <!-- count(offers) -->
                    </table>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="10" class="text-center text-danger">No promotions defined.</td>
            </tr>
        @endforelse
        </tbody>
    </table>

    <!-- promotionEdit Modal -->
    <div class="modal " id="promotionEditDialog" tabindex="-1" role="dialog" aria-labelledby="promotionEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h2 class="modal-title" id="promotionEditLabel">Maintain Promotion</h2>
                </div>
                <div class="modal-body">
                    <form id="promotionEditForm">
                        {{ csrf_field() }}
                        <input type="hidden" id="promotionId" value="" v-model="promotionId">
                        <input type="hidden" id="promotionAction" value="" v-model="promotionAction">

                        @if ( count($promotionGroups) > 0 )
                            <div class="form-group">
                                <label for="editPromotionGroupId">Promotion Group:</label>
                                <select style="display: block; width: 100%;" class="form-control" name="editPromotionGroupId" id="editPromotionGroupId" v-model="promotion.promotion_group_id">
                                    @foreach($promotionGroups as $promotionGroup)
                                        <option value="{{ $promotionGroup['id'] }}" @if ($promotionGroup['id'] == "$promotionGroupId")selected="selected"@endif>{{ $promotionGroup['name'] }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @else
                            <input type="hidden" name="promotionGroupId" value="1" />
                        @endif

                        <div class="form-group">
                            <label for="promotionName">Name</label>
                            <input class="form-control" id="promotionName" placeholder="Enter Promotion Name" v-model="promotion.name">
                        </div>

                        <div class="form-group">
                            <label for="promotionDescription">Description</label>
                            <textarea class="form-control" id="promotionDescription" rows="3" v-model="promotion.description"></textarea>
                        </div>

                        <div class="form-group">
                            <label for="promotionStartDate">Start Date</label>
                            <input type="text" id="promotionStartDate" class="form-control datepicker" v-model="promotion.start_date"/>
                        </div>

                        <div class="form-group">
                            <label for="promotionEndDate">End Date</label>
                            <input type="text" id="promotionEndDate" class="form-control datepicker" v-model="promotion.end_date"/>
                        </div>

                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" class="form-check-input" id="promotionStatus" value="1" v-model="promotion.status">
                                Active
                            </label>
                        </div>

                    </form>


                            <div class="form-group row" id="multipleCapsDiv" style="margin: 1px;">
                                <div class="panel panel-default">
                                    <div class="panel-heading"><b>Earning Caps</b></div>
                                    <div class="panel-body">
                                        <table class="table" id="valuesList">
                                            <thead class="thead-default">
                                            <tr>
                                                <th>Start Date</th>
                                                <th>End Date</th>
                                                <th>Name</th>
                                                <th>Period</th>
                                                <th>Max Value</th>
                                                <th>Status</th>
                                                <th class="text-right">
                                                    <a type="button" class="btn btn-sm btn-success" id="newCap" @click.prevent="newCap()">New Cap</a>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="(promotionCap, index) in promotion.caps" :key="index">
                                                <td v-html="renderDate(promotionCap.start_date)"></td>
                                                <td v-html="renderDate(promotionCap.end_date)"></td>
                                                <td v-html="promotionCap.name"></td>
                                                <td v-html="renderPeriod(promotionCap.max_period)"></td>
                                                <td v-html="renderAmount(promotionCap.max_value)" align="right"></td>
                                                <td v-html="(promotionCap.status ? 'active' : '')"></td>
                                                <td class="text-right text-nowrap">
                                                    <a type="button" class="btn btn-sm btn-default" @click.prevent="editCap(promotionCap)">Edit</a>
                                                    <a type="button" class="btn btn-sm btn-danger" @click.prevent="deleteCap(promotionCap)">Delete</a>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                    <!-- panel-body  -->
                                </div>
                                <!-- panel -->
                            </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="promotionSave"  @click.prevent="savePromotion()">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!-- promotionEdit Modal End -->

    <!-- capEdit Modal -->
    <div class="modal " id="capEditDialog" tabindex="-1" role="dialog" aria-labelledby="capEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h2 class="modal-title" id="capEditLabel">Maintain Cap</h2>
                </div>
                <div class="modal-body">

                  <form id="capEditForm">
                        {{ csrf_field() }}
                        <input type="hidden" id="capIndex" value="" v-model="capIndex">
                        <input type="hidden" id="capId" value="" v-model="editCapItem.id">
                        <input type="hidden" id="capAction" value="" v-model="capAction">

                    <div class="form-group">
                        <label for="capName">Name</label>
                        <input class="form-control" id="capName" placeholder="Enter Cap Name" v-model="editCapItem.name">
                    </div>

                    <div class="form-group">
                        <label for="capDescription">Description</label>
                        <textarea class="form-control" id="capDescription" rows="3" v-model="editCapItem.description"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="capStartDate">Start Date</label>
                        <input type="text" id="capStartDate" class="form-control datepicker" v-model="renderDate(editCapItem.start_date)"/>
                    </div>

                    <div class="form-group">
                        <label for="capEndDate">End Date</label>
                        <input type="text" id="capEndDate" class="form-control datepicker" v-model="renderDate(editCapItem.end_date)"/>
                    </div>

                    <div class="form-group">
                        <label for="capMaxValue">Max Value</label>
                        <input type="text" id="capMaxValue" class="form-control" v-model="editCapItem.max_value"/>
                    </div>

                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="checkbox" class="form-check-input" id="capStatus" value="1" v-model="editCapItem.status">
                            Active
                        </label>
                    </div>

                    <div class="form-group">
                        <label for="capFiscalMonth">Fiscal Month</label>
                        <select class="form-control" style="display: block; width: 100%;" id="capFiscalMonth" name="capFiscalMonth" v-model="editCapItem.fiscal_month">
                            <option value="">--- Select Period ---</option>
                            @foreach($fiscalMonths as $value => $text)
                                <option value="{{ $value }}">{{ $text }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="capMaxPeriod">Max Value During a Period</label>
                        <select class="form-control" style="display: block; width: 100%;" id="capMaxPeriod" name="capMaxPeriod" v-model="editCapItem.max_period">
                            <option value="">--- Select Period ---</option>
                            @foreach($maxPeriods as $value => $text)
                                <option value="{{ $value }}">{{ $text }}</option>
                            @endforeach
                        </select>
                    </div>

                  </form>

                </div>
                <!-- modal-body -->

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="capSave" @click.prevent="saveCap(editCapItem)">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!-- capEdit Modal End -->
@endsection

@section('tab_after')
</div>
@endsection

@section('js')
    @parent
    @include('Claim::partials.vue');

    <script>

    var maxPeriods = {!! json_encode($maxPeriods, JSON_PRETTY_PRINT); !!};

    $(document).ready(function(){
        $('#campaignId').change(function() {
            var campaignId = $('#campaignId').val();
            var url = '/admin/offer/promotions/' + campaignId;
            window.location.replace(url);
        });
    });  // document ready

    </script>

    <script type="text/javascript" src="{{ url('/vendor/ignite/js/offer/promotion.js') }}"></script>
@endsection
