@extends('Claim::layouts.entry')

@section('page_heading', 'Issue Claims')
@section('page_breadcrumb', 'Issue Claims')

@section('page_content')

    <div id="claims-processing">
        <div class="box box-primary">
            <div class="box-body">
                <form action="{{ route('admin.claim.issue.update') }}" method="post" name="selected" id="selected">
                    <input id="selected-items" type="hidden" name="items" value=""/>
                    <input id="selected-status" type="hidden" name="status" value=""/>
                    {{ csrf_field() }}
                </form>
                {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            </div>
        </div>
    </div>
    @include('Claim::partials.dialog.reason')
    @include('Claim::partials.dialog.quickview')
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/select/1.2.3/js/dataTables.select.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script src="{{ asset('vendor/ignite/js/claim/process/reason-modal.js') }}"></script>
    <script type="text/javascript">
      jQuery(document).ready(function($) {
        var $dataTable = $('#dataTableBuilder');
        $dataTable.customButtons({
          buttons: [{
            enabled: false,
            text: '<span class="fa fa-times text-danger"></span> <span class="text-danger">Cancel</span>',
            action: function (e, dt, node, conf) {
              e.preventDefault();
              var selected = dt.column(0).checkboxes.selected();
              new window.ReasonModal({
                required: true,
                titleText: 'Cancel Claim Participants',
                labelText: 'Reason for Cancellation',
                buttonText: 'Cancel',
                onSuccess: $.proxy(function(reason) {
                  $('#selected-reason').val(reason);
                  $('#selected-status').val('cancelled');
                  $('#selected-items').val(selected.map(function(box) {
                    return $(box).val();
                  }).join(','));
                  $('#selected').submit();
                  $('#reason-dialog-proceed').text('Cancelling...').prop('disabled', true);
                  $('#reason-submit-message').removeClass('hide').text('Submitting...please wait');
                  $('#reason-note-field').addClass('hide');
                }, this),
                onFailure: $.proxy(function(reason, error) {
                  error.text('Please enter a useful reason for cancelling the claim.')
                }, this)
              });
            }
          }, {
            enabled: false,
            text: '<span class="fa fa-check text-success"></span> <span class="text-success button-text-issueing">Issue</span>',
            action: function (e, dt, node, conf) {
              e.preventDefault();
              $(node).prop('disabled', true);
              $(node).find('.button-text-issueing').text('Issueing...');
              var selected = dt.column(0).checkboxes.selected();
              $('#selected-status').val('issued');
              $('#selected-items').val(selected.map(function (box) {
                return $(box).val();
              }).join(','));
              $('#selected').submit();

            }
          }]
        });

        $(document).on('click', '.btn-view',  function(e) {
          e.preventDefault();
          var url = $(this).attr('href');
          $.ajax({
            url: url,
            type: 'GET',
            success: function(data, textStatus, jqXHR) {
              var dialog = $('#quickview-dialog');
              dialog.modal('show');
              dialog.find('.modal-body').html(data);
              $('#quickview-dialog-edit').attr('href', url.replace('quickview', 'edit'));
            }
          });
        });
      });
    </script>
@endsection
