<?php

namespace Ignite\Claim\Entities\Dynamic;

class IgniteDB
{
    public static function create($databaseType = 'mariadb')
    {
        $databaseType = strtolower($databaseType);

        switch ($databaseType) {
            case 'mariadb':
            case 'mysql':
                return new MariaDB();
                break;

            default:
                printf("IgniteDB:: Unknown Datbase Type '%s', bailing...\n", $databaseType);
                return false;
                break;
        }
    }

    public static function get($name)
    {
        $connection     = config('database.default', false);
        $dbConfig       = config('database.connections.' . $connection, false);
        $database       = $dbConfig['database'];
        $driver         = $dbConfig['driver'];

        switch ($name) {
            case 'connection':
                return $connection;
                break;

            case 'config':
            case 'dbConfig':
                return $dbConfig;
                break;

            case 'database':
            case 'databaseName':
                return $database;
                break;

            case 'driver':
                return $driver;
                break;

            case 'db':
            case 'IgniteDb':
                return self::create($driver);
                break;
        }

        return false;
    }

    public static function getTables($databaseName = false)
    {
        if (! $databaseName) {
            $databaseName = self::get('databaseName');
        }

        $driver = self::get('driver');

        return self::create($driver)->getTables($databaseName);
    }

    public static function getColumns($tableName, $databaseName = false)
    {
        if (! $databaseName) {
            $databaseName = self::get('databaseName');
        }

        $driver = self::get('driver');

        return self::create($driver)->getDbColumns($databaseName, $tableName);
    }

    public static function getColumnsNative($tableName, $databaseName = false, $asArray = true)
    {
        if (! $databaseName) {
            $databaseName = self::get('databaseName');
        }

        $driver = self::get('driver');

        return self::create($driver)->getColumns($databaseName, $tableName, $asArray);
    }
}
