<?php

namespace Ignite\Claim\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Claim\Entities\OfferCampaign;
use Ignite\Claim\Entities\OfferPromotionGroup;

class OfferPromotionGroupsTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        //$offerPromotionGroupRepository = app(OfferPromotionGroupRepository::class);
        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/offer_promotion_groups.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        //OfferPromotionGroup::truncate();

        foreach ($sources as $source) {
            try {
                OfferPromotionGroup::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
