@php
    $user = isset($history->user) ? $history->user->fullName() : 'Unknown';
    $entity = $history->getReadableEntityName();
    $created = $history->created_at->format('jS M Y @ H:ia');
@endphp

@if ($history->event === 'updated')
    <tr class="updated">
        <td width="210" nowrap>{{ $created }}</td>
        <td width="180">{{ $user }}</td>
        <td>
            @php $modifications = $history->getModified(); @endphp
            @if (count($modifications) > 10)
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th>Field</th>
                        <th>Old Value</th>
                        <th>New Value</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($history->getModified() as $attribute => $values)
                        <tr>
                            <td>{{ $attribute }}</td>
                            <td>{{ empty($values['old']) ? '""' : $values['old'] }}</td>
                            <td>{{ empty($values['new']) ? '""' : $values['new'] }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                @foreach ($modifications as $attribute => $values)
                    <p>{{ ucwords($history->event) }} {{ $entity }} value `{{ $attribute }}` from <strong>{{ empty($values['old']) ? '""' : $values['old'] }}</strong> to <strong>{{ ! is_string($values['new']) ? (is_array($values['new']) && isset($values['new']['date'])) ? \Carbon\Carbon::createFromFormat('Y-m-d H:i:s.u', $values['new']['date']) : json_encode($values['new']) : $values['new'] }}</strong></p>
                @endforeach
            @endif
        </td>
    </tr>
@else
    <tr class="{{ $history->event }}">
        <td width="210" nowrap>{{ $created }}</td>
        <td width="180">{{ $user }}</td>
        <td>
            {{ ucwords($history->event) }} {{ $entity }} <strong>{{ $history->getReadableIdentifier() }}</strong>
        </td>
    </tr>
@endif
