@extends('Core::layouts.main')

@section('css')
@parent

<style>
.offerRow {
  display: none;
}

.controlsDiv {
  background-color: #cccccc;
  margin-bottom: 5px;
}

.text-nowrap {
  white-space: nowrap;
}
</style>

@endsection

@section('page_content')

<h1>Offers</h1>

<div class="row form-inline controlsDiv">
@if ( count($campaigns) > 0 )
  <div class="col-md-3 controlsDiv">
    <label for="campaignId" class="control-label">Campaign:&nbsp;</label>
      <select class="form-control" size="1" name="campaignId" id="campaignId">
      @foreach($campaigns as $campaign)
        <option value="{{ $campaign['id'] }}" @if ($campaign['id'] == "$campaignId")selected="selected"@endif>{{ $campaign['name'] }}</option>
      @endforeach
      </select>
  </div>
@else
  <input type="hidden" name="campaignId" value="1" />
@endif

@if ( count($promotions) > 0 )
  <div class="col-md-6 controlsDiv">
    <label for="promotionId" class="control-label">Promotion:&nbsp;</label>
      <select class="form-control" size="1" name="promotionId" id="promotionId">
      @foreach($promotions as $promotion)
        <option value="{{ $promotion['id'] }}" @if ($promotion['id'] == "$promotionId")selected="selected"@endif>{{ $promotion['name'] }}</option>
      @endforeach
      </select>
  </div>
@elseif ( count($campaigns) > 0 )
  <div class="col-md-6 controlsDiv">
    No Promotions created for this Campaign.
  </div>
@else
  <input type="hidden" name="promotionId" value="1" />
@endif
</div>

<table class="table" id="offersTable">
  <thead>
    <tr>
      <th>#</th>
      <th>Offer Group</th><th>Name</th>
      <th>SKU</th>
      <th>Start Date</th>
      <th>End Date</th>
      <th>Grace Date</th>
      <th>Status</th>
      <th>
          @if ( count($promotions) > 0 )
          <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#offerEditDialog" data-offer_id="new">New Offer</button>
          @else
          &nbsp;
          @endif
      </th>
    </tr>
  </thead>
  <tbody>
    @if (count($offers) > 0 )
      @foreach($offers as $offer)

      <tr data-offer_id="{{ $offer['id'] }}">
        <td>{{ $offer['id'] }}</td>
        <td>{{ $offer['offer_group'] }}</td><td>{{ $offer['name'] }}</td>
        <td>{{ $offer['sku'] }}</td>
        <td>{{ Format::date($offer['start_date']) }}</td>
        <td>{{ Format::date($offer['end_date']) }}</td>
        <td>{{ Format::date($offer['grace_date']) }}</td>
        <td>{{ ($offer['status'] == 1) ? 'active' : '' }}</td>
        <td class="text-right text-nowrap">
          <button type="button" class="btn btn-sm btn-default" data-toggle="modal" data-target="#offerEditDialog" data-offer_id="{{ $offer['id'] }}" data-offer_action="edit" >
            Edit
          </button>
          @if ( empty($offer['has_claims']) )
          <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#offerEditDialog" data-offer_id="{{ $offer['id'] }}" data-offer_action="delete" >
            Delete
          </button>
          @endif
        </td>
      </tr>

      @endforeach <!-- offers -->
    @else
      <tr>
        <td colspan="10"><h1>No Offers Defined for Promotion selected.</h1></td>
      </tr>
    @endif
  </tbody>
</table>

<!-- Edit Offer Modal -->
<div class="modal " id="offerEditDialog" tabindex="-1" role="dialog" aria-labelledby="offerEditLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h2 class="modal-title" id="offerEditLabel">Maintain Offer</h2>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form>
          {{ csrf_field() }}
          <input type="hidden" id="offerId" value="">
          <input type="hidden" id="offerAction" value="">
          <input type="hidden" id="editPromotionId" value="1" />

          <div class="form-group">
            <label for="offerName">Name</label>
            <input class="form-control" id="offerName" placeholder="Enter Offer Name">
          </div>

          <div class="form-group">
            <label for="offerSku">SKU</label>
            <input class="form-control" id="offerSku">
          </div>

          <div class="form-group">
            <label for="offerGroup">Offer Group</label>
            <input class="form-control" id="offerGroup">
          </div>

          <div class="form-group">
            <label for="offerDescription">Description</label>
            <textarea class="form-control" id="offerDescription" rows="3"></textarea>
          </div>

          <div class="form-group row" style="margin-right: 20px;">
            <div class="form-inline">
              <div class="col-md-4">
                <label for="offerStartDate text-nowrap">Start Date</label>
                <input type="text" id="offerStartDate" class="form-control datepicker" />
              </div>
              <div class="col-md-4">
                <label for="offerEndDate text-nowrap">End Date</label>
                <input type="text" id="offerEndDate" class="form-control datepicker" />
              </div>
              <div class="col-md-4">
                <label for="offerGraceDate text-nowrap">Grace Date</label>
                <input type="text" id="offerGraceDate" class="form-control datepicker" />
              </div>
            </div>
          </div>

          <div class="form-check">
          </div>

          <div class="form-group row">
            <div class="form-inline">
                <div class="col-md-1"></div>
                <label class="form-check-label col-md-2">
                  <input type="checkbox" class="form-check-input" id="offerStatus" value="1">
                   Active
                </label>
                <div class="col-md-6">
                  <label class="" for="offerValueModeId">Value Mode:</label>
                  &nbsp;&nbsp;&nbsp;
                  <div class="checkbox">
                    <label>
                      <input type="radio" name="offerValueModeId" value="1"> Single
                    </label>
                  </div>
                  &nbsp;&nbsp;&nbsp;
                  <div class="checkbox">
                    <label>
                      <input type="radio" name="offerValueModeId" value="2"> Multiple
                    </label>
                  </div>
                </div>
              </div>
            </div>


            <div class="form-group row hidden" id="singleValueDiv" style="margin: 1px;">
              <div class="panel panel-default">
                <div class="panel-heading"><b>Single Value</b></div>

                <div class="panel-body">

                      <div class="form-group row">
                          <label class="col-md-4" for="value">Value Type:</label>
                          <div class="col-md-4">
                              <select class="form-control" size="1" id="offerValueTypeId" name="offerValueTypeId">
                                  @foreach($valueTypeOptions as $value => $text)
                                    <option value="{{ $value }}" @if ($value == $offer['value_type_id'])selected="selected"@endif>{{ $text }}</option>
                                  @endforeach
                              </select>
                          </div>
                      </div>

                      <div class="form-group row">
                          <label class="col-md-4" for="offerFalue">Value:</label>
                          <div class="col-md-4">
                              <input type="text" class="form-control" id="offerValue" name="offerValue" value="{{ $offer['value'] }}" required>
                          </div>
                      </div>

                </div>
                <!-- panel-body -->

              </div>
              <!-- panel -->
            </div>
            <!-- form-group row -->


            <div class="form-group row hidden" id="multipleValuesDiv" style="margin: 1px;">
              <div class="panel panel-default">
                <div class="panel-heading"><b>Values by Participant</b></div>

                  <div class="panel-body">

                    <table class="table" id="valuesList">
                      <thead class="thead-default">
                        <tr>
                          <th>Participant</th>
                          <th>Value Type</th>
                          <th>Value</th>
                          <th class="text-right">
                              <a type="button" class="btn btn-sm btn-success" id="newValue" data-id="new">New Value</a>
                          </th>
                        </tr>
                      </thead>
                      <tbody>
                      @if (count($offer['values']) > 0 )
                        @foreach($offer['values'] as $value)
                        <tr class="bg-white" data-id="{{ $value['id'] }}" data-index="{{ $loop->index  }}">
                            <td data-participant_type="{{ $value['participant_type'] }}">{{ $participantTypes[$value['participant_type']] }}</td>
                            <td data-value_type_id="{{ $value['value_type_id'] }}">{{ $valueTypeOptions[$value['value_type_id']] }}</td>
                            <td data-value="{{ $value['value'] }}">{{ $value['value'] }}</td>
                            <td class="text-right text-nowrap">
                                <a type="button" class="btn btn-sm btn-default valueEdit" data-id="{{ $value['id'] }}">Edit</a>
                                <a type="button" class="btn btn-sm btn-danger valueDelete" data-id="{{ $value['id'] }}">Delete</a>
                            </td>
                        </tr>
                        @endforeach <!-- offer[values] -->
                      @else
                      <tr class="noRows">
                          <td colspan="10" class="bg-warning">No Participant Values Defined.</td>
                      </tr>
                      @endif
                      </tbody>
                    </table>

                  </div>
                  <!-- panel-body  -->
              </div>
              <!-- panel -->
            </div>






        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="offerSave">Save</button>
      </div>
    </div>
  </div>
</div>

<!-- Value Dialog -->
<div class="modal " id="valueEditDialog" tabindex="-1" role="dialog" aria-labelledby="valueEditLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h2 class="modal-title" id="valueEditLabel">Maintain Value</h2>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <form id="valueForm">

          <input type="hidden" id="valueIndex" />
          <input type="hidden" id="valueId" />

          <div class="form-group">
            <label for="valueName">Type</label>
            <select class="form-control" size="1" id="valueName">
                <option value="">-- Select --</option>
                @foreach($participantTypes as $value => $text)
                  <option value="{{ $value }}">{{ $text }}</option>
                @endforeach
            </select>
          </div>

          <div class="form-group">
            <label for="valueType">Mode</label>
            <select class="form-control" size="1" id="valueType">
                @foreach($valueTypeOptions as $value => $text)
                  <option value="{{ $value }}">{{ $text }}</option>
                @endforeach
            </select>
          </div>

          <div class="form-group">
            <label for="valueValue">Value</label>
            <input class="form-control" id="valueValue">
          </div>

        </form>

      </div>
      <!-- modal-body -->

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-success hidden" id="valueAdd">Add</button>
        <button type="button" class="btn btn-danger hidden" id="valueDelete">Delete</button>
        <button type="button" class="btn btn-primary hidden" id="valueSave">Save</button>
      </div>
    </div>
  </div>
</div>

@endsection

@section('js')
@parent

<script>

$(document).ready(function(){

    function clearOfferDialog()
    {
        $('#offerName').val('');
        $('#offerSku').val('');
        $('#offerGroup').val('');
        $('#offerDescription').val('');
        $('#offerStartDate').val('');
        $('#offerEndDate').val('');
        $('#offerGraceDate').val('');
        $('#offerStatus').prop('checked', true);
        $('#editPromotionId').val($('#promotionId').val());

        $('[name="offerValueModeId"]').filter('[value=1]').prop('checked', true)
        $('[name="offerValueModeId"]').filter('[value=2]').prop('checked', false)

        $('#offerValueTypeId').val('1');
        $('#offerValue').val('0');

        $('#valuesList tbody').empty();
        var html  = '<tr class="noRows">' + "\n";
            html += '      <td colspan="10" class="bg-warning">No Participant Values Defined.</td>' + "\n";
            html += '  </tr>' + "\n";
        $('#valuesList tbody').append(html);
    }

    function populateOfferDialog(offerId)
    {
        clearOfferDialog();

        $.ajax({
            type: 'GET',
            url: '/offer/api/offer/get/' + offerId,
            dataType: 'json',
            success: function(result){
                var offer = result.data;
                var startDate = ( parseInt(offer.start_date) > 0 ) ? moment(offer.start_date).format('M/D/YYYY') : '';
                var endDate = ( parseInt(offer.end_date) > 0 ) ? moment(offer.end_date).format('M/D/YYYY') : '';
                var graceDate = ( parseInt(offer.grace_date) > 0 ) ? moment(offer.grace_date).format('M/D/YYYY') : '';
                $('#editPromotionId').val(offer.promotion_id);
                $('#offerName').val(offer.name);
                $('#offerSku').val(offer.sku);
                $('#offerGroup').val(offer.offer_group);
                $('#offerDescription').val(offer.description);
                $('#offerStartDate').val(startDate);
                $('#offerEndDate').val(endDate);
                $('#offerGraceDate').val(graceDate);
                $('#offerValue').val(offer.value);
                $('#offerValueTypeId').val(((offer.value_type_id > 0) ? offer.value_type_id : 1));

                if ( offer.value_mode_id == 2 ) {
                    var $valueMode = $('[name="offerValueModeId"]').filter('[value=2]').prop('checked', true);
                }
                else {
                    var $valueMode = $('[name="offerValueModeId"]').filter('[value=1]').prop('checked', true);
                }
                $valueMode.trigger('change');

                if ( offer.status == 1 )
                   $('#offerStatus').prop('checked', true);
                else
                   $('#offerStatus').prop('checked', false);

                $('.datepicker').each(function() {
                    $(this).datepicker('update');
                });
            },
            error: function(xhr, ajaxOptions, thrownError) {
                var messages = window.Ignite.Core.getResponseErrors(xhr, 'xhr.responseJSON.messages');
                alert('Unable to Get Offer for id = ' + offerId + "\n" + messages + xhr.status + ': ' + thrownError);
                $("#offerEditDialog").modal('hide');
            }
        });
    }

    function saveOffer()
    {
        var offerId = $('#offerId').val();

        var data = {};
        data._token = $('[name=_token]').val();
        data.id = $('#offerId').val();
        data.promotion_id = $('#editPromotionId').val();
        data.name = $('#offerName').val();
        data.sku = $('#offerSku').val();
        data.offer_group = $('#offerOfferGroup').val();
        data.description = $('#offerDescription').val();
        data.start_date = $('#offerStartDate').val();
        data.end_date = $('#offerEndDate').val();
        data.grace_date = $('#offerGraceDate').val();
        data.status = ($('#offerStatus').prop('checked')) ? 1 : 0;
        data.campaign_id = $('#campaignId').val();

        data.value_type_id = $('#offerValueTypeId').val();
        data.value_mode_id = $('[name="offerValueModeId"]:checked').val();
        data.value = $('#offerValue').val();

        $.ajax({
            type: 'POST',
            url: '/offer/api/offer/store',
            data: data,
            dataType: 'json',
            success: function(result){
                var offer = result.data;
                $("#offerEditDialog").modal('hide');
                location.reload();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                var messages = window.Ignite.Core.getResponseErrors(xhr, 'xhr.responseJSON.messages');
                alert('Unable to Update Offer id = ' + offerId + "\n" + messages + xhr.status + ': ' + thrownError);
            }
        });
    }

    function deleteOffer()
    {
        var data = {};
        data._token = $('[name=_token]').val();
        data.id = $('#offerId').val();

        $.ajax({
            type: 'POST',
            url: '/offer/api/offer/delete',
            data: data,
            dataType: 'json',
            success: function(result){
                var offer = result.data;
                $("#offerEditDialog").modal('hide');
                location.reload();
            },
            error: function(xhr, ajaxOptions, thrownError) {
                var messages = window.Ignite.Core.getResponseErrors(xhr, 'xhr.responseJSON.messages');
                alert('Unable to Delete Offer id = ' + offerId + "\n" + messages + xhr.status + ': ' + thrownError);
            }
        });
    }

    $('#offerEditDialog').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        // Extract action from data-* attributes
        var action = button.data('offer_action');
        var offerId = button.data('offer_id');

        $('#offerId').val(offerId);

        $('.modal-header').removeClass('bg-info');
        $('.modal-header').removeClass('bg-success');
        $('.modal-header').removeClass('bg-danger');

        if ( action == 'delete' ) {
            $('#offerEditLabel').html('DELETE Offer');
            $('#offerAction').val('delete');
            $('#offerSave').html('Delete');
            $('.modal-header').addClass('bg-danger');
            populateOfferDialog(offerId);
        }
        else {
            if ( offerId == 'new' ) {
                $('#offerEditLabel').html('ADD New Offer');
                $('#offerAction').val('new');
                $('#offerSave').html('Create');
                $('.modal-header').addClass('bg-success');
                clearOfferDialog(offerId);
            }
            else {
                $('#offerEditLabel').html('EDIT Offer');
                $('#offerAction').val('update');
                $('#offerSave').html('Update');
                $('.modal-header').addClass('bg-default');
                populateOfferDialog(offerId);
            }
        }
    });

    function updatePromotionSelect(campaignId)
    {
        $.ajax({
            type: 'GET',
            url: '/offer/api/promotion/forcampaign/' + campaignId,
            dataType: 'json',
            success: function(result){
                var promotions = result.data;

                var promotionId = 0;
                $('#promotionId').empty();
                for(var ii in promotions) {
                    var option = '<option value="' + promotions[ii]['id'] + '">' + promotions[ii]['name'] + '</option>';
                    $('#promotionId').append(option);
                    if ( promotionId == 0 ) {
                        promotionId = promotions[ii]['id'];
                    }
                };

                var url = '/offer/offers/' + promotionId + '/' + campaignId;
                window.location.replace(url);
            },
            error: function(xhr, ajaxOptions, thrownError) {
                var messages = window.Ignite.Core.getResponseErrors(xhr, 'xhr.responseJSON.messages');
                alert('Unable to get Promotions for Campaign id = ' + campaignId + "\n" + messages + xhr.status + ': ' + thrownError);
            }
        });
    }

    $('#offerSave').click(function (event) {
        var action = $('#offerAction').val();

        if ( action == 'delete' )
            deleteOffer();
        else
            saveOffer();
    });

    $('#campaignId').change(function() {
        var campaignId = $('#campaignId').val();
    	updatePromotionSelect(campaignId);
    });

    $('#promotionId').change(function() {
        var promotionId = $('#promotionId').val();
        var url = '/offer/offers/' + promotionId;
        window.location.replace(url);
    });

    $('[name="offerValueModeId"]').change(function() {
        if ( $(this).val() == '2' ) {
            $('#singleValueDiv').addClass('hidden');
            $('#multipleValuesDiv').removeClass('hidden');
        }
        else {
            $('#multipleValuesDiv').addClass('hidden');
            $('#singleValueDiv').removeClass('hidden');
        }
    });

    $('.datepicker').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        pickDate: true
    }).on('show.bs.modal', function(event) {
        // Prevent ditepicker from firing bootstrap modal "show.bs.modal"
        event.stopPropagation(); 
    });

    $('#offersTable').DataTable({
        columnDefs: [{orderable: false, targets: [9] }],
        order: [[2, 'asc']],
    });

});  // document ready

</script>

@endsection
