<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferPromotionCap extends Model
{
    use ValidatesFields;

    protected $table        = 'claim_offer_promotion_cap';
    protected $primaryKey   = 'id';

    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'offer_promotion_id'    => [ 'type' => 'integer'],
        'name'                  => [ 'type' => 'string'],
        'description'           => [ 'type' => 'string'],
        'start_date'            => [ 'type' => 'date'],
        'end_date'              => [ 'type' => 'date'],
        'fiscal_month'          => [ 'type' => 'integer',           'default' => '1'],
        'max_period'            => [ 'type' => 'string'],
        'value_type_id'         => [ 'type' => 'integer',           'default' => '1'],
        'max_value'             => [ 'type' => 'float'],
        'status'                => [ 'type' => 'integer',           'default' => '1'],
    ];

    public static $maxPeriods = [
        'month'     => 'Per Month',
        'quarter'   => 'Per Quarter',
        'semi'      => 'Per 6 Months',
        'year'      => 'Per Year',
    ];

    public static $fiscalMonths = [
        '1'         => '1 - January',
        '2'         => '2 - February',
        '3'         => '3 - March',
        '4'         => '4 - April',
        '5'         => '5 - May',
        '6'         => '6 - June',
        '7'         => '7 - July',
        '8'         => '8 - August',
        '9'         => '9 - September',
        '10'        => '10 - October',
        '11'        => '11 - November',
        '12'        => '12 - December',
    ];

    public function promotion()
    {
        return $this->belongsTo('Ignite\Claim\Entities\OfferPromotion', 'offer_promotion_id');
    }
}
