@extends('Claim::layouts.tables')

@section('page_heading', 'Create New Table')
@section('page_breadcrumb', 'Create New Table')

@section('page_content')
<div class="row">
    <div class="col-md-6 col-md-offset-3">
        <form class="form-horizontal">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">New Table</h3>
                </div>
                <div class="box-body">
                    <div class="alert alert-info">
                        Please select a Table and press the "Create" button.
                    </div>
                    <div class="form-group">
                        <label for="tableSelect" class="control-label col-md-2">Table:</label>
                        <div class="col-md-6">
                            <select class="form-control" id="tableSelect" size="1">
                                <option value="">-- Select --</option>
                                @foreach($tables as $table)
                                    <option value="{{ $table }}">{{ $table }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="box-footer">
                    <button type="button" class="btn btn-default pull-left" id="cancelButton"><span class="text-danger">Cancel</span></button>
                    <button type="button" class="btn btn-primary pull-right" id="createButton">Create</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection

@push('js')
<script>
$(document).ready(function(){

    $('#cancelButton').click(function() {
        window.location = "{{ url('/admin/settings/tables') }}";
    });

    $('#createButton').click(function() {
        var tableName = $('#tableSelect').val();

        if ( tableName == '' ) {
            alert('Please select a table to create.');
            return false;
        }

        window.location = "{{ url('/admin/settings/tables/edit') }}" + '/' + tableName;
    });

});
</script>
@endpush
