@extends('Claim::admin.offers.layouts.master')

@section('page_heading', 'User Promotion Groups')
@section('page_breadcrumb', 'User Promotion Groups')

@section('tab_buttons')
@endsection

@section('tab_content')

    <table class="table table-bordered table-striped table-responsive table-responsive table-data" id="usersTable">
        <thead>
            <tr>
                <th nowrap width="10">&nbsp;</th>
                <th nowrap width="10">ID</th>
                <td>Username</td>
                <th>Name</th>
                <th nowrap width="70">Groups</th>
            </tr>
        </thead>
        <tbody>
        @forelse($users as $user)
            <tr>
                <td>
                    <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#groupsSelectDialog" data-user_id="{{ $user['user_id'] }}" >
                        Groups
                    </button>
                </td>
                <th scope="row" class="userId">{{ $user['user_id'] }}</th>
                <td class="userName">{{ $user['username'] }}</td>
                <td class="fullName">{{ $user['first'] . ' ' . $user['last'] }}</td>
                <td>{{ (count($user['promotion_groups'])) ? count($user['promotion_groups']) : 0 }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="10" class="text-center text-danger">No users defined.</td>
            </tr>
        @endforelse
        </tbody>
    </table>

    <!-- Groups Show/Select Dialog -->
    <div class="modal " id="groupsSelectDialog" tabindex="-1" role="dialog" aria-labelledby="groupsSelectLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header bg-info">
                    <h5 class="modal-title" id="groupsSelectLabel">Promotion Groups for User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Name:&nbsp;&nbsp;</label><span id="userNameDisplay"></span>
                    </div>

                    <hr>
                    <p>

                    <form>
                        {{ csrf_field() }}
                        <input type="hidden" id="groupsUserId" value="" >

                        <div class="row">

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="groupsSelect">Available Promotion Groups</label>
                                    <select multiple class="form-control" size="10" name="from[]" id="groupsSelect">
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-md-2">
                                    <!--
                                                  <button type="button" id="groupsSelect_undo" class="btn btn-block">undo</button>
                                    -->
                                    <button type="button" id="groupsSelect_rightAll" class="btn btn-block"><i class="glyphicon glyphicon-forward"></i></button>
                                    <button type="button" id="groupsSelect_rightSelected" class="btn btn-block"><i class="glyphicon glyphicon-chevron-right"></i></button>
                                    <button type="button" id="groupsSelect_leftSelected" class="btn btn-block"><i class="glyphicon glyphicon-chevron-left"></i></button>
                                    <button type="button" id="groupsSelect_leftAll" class="btn btn-block"><i class="glyphicon glyphicon-backward"></i></button>
                                    <!--
                                                  <button type="button" id="groupsSelect_redo" class="btn btn-block">redo</button>
                                    -->
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="groupsSelect_to">User Has Promotion Groups</label>
                                    <select multiple class="form-control" size="10" name="to[]" id="groupsSelect_to">
                                    </select>
                                </div>
                            </div>

                        </div> <!-- row -->

                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="groupsSave">Save</button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
    @parent

    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/vendor/multiselect/multiselect.js') }}"></script>

    <script>
        $(document).ready(function(){

            function saveUserGroups()
            {
                var userId = $('#groupsUserId').val();

                var data = {};
                data._token       = $('[name=_token]').val();
                data.userId    = userId;
                data.hasGroups    = {};

                $('#groupsSelect_to option').each(function() {
                    data.hasGroups[$(this).val()] = $(this).text();
                });

                $.ajax({
                    type: 'POST',
                    url: '/offer/api/promotiongroup/usergroupsstore',
                    data: data,
                    dataType: 'json',
                    success: function(response){
                        alert('User Promotion Groups Updated.');
                        $("#groupsSelectDialog").modal('hide');
                        location.reload();
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to Update Promotion Groups for User id = ' + userId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#groupsSelectDialog').on('show.bs.modal', function (event) {
                var button = $(event.relatedTarget) // Button that triggered the modal
                // Extract info from data-* attributes
                var userId = button.data('user_id')

                $('#groupsSelect').empty();
                $('#groupsSelect_to').empty();

                $.ajax({
                    type: 'GET',
                    url: '/offer/api/promotiongroup/usergroups/' + userId,
                    dataType: 'json',
                    success: function(response){
                        var user = response.data.user;
                        var notHasGroups = response.data.notHasGroups;
                        var hasGroups = response.data.hasGroups;

                        $('#userNameDisplay').html('(' + user.username + ') ' + user.first + ' ' + user.last);
                        $('#groupsUserId').val(user.user_id);

                        $.each(notHasGroups, function(index, group) {
                            $('#groupsSelect').append($('<option>', {value:group.id, text:group.name}));
                        });

                        $.each(hasGroups, function(index, group) {
                            $('#groupsSelect_to').append($('<option>', {value:group.id, text:group.name}));
                        });
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert('Unable to get Groups for User id = ' + userId + "\n" + xhr.status + ': ' + thrownError);
                    }
                });
            });

            $('#groupsSave').click(function() {
                saveUserGroups();
            });

            $('#groupsSelect').multiselect();

            $('#usersTable').DataTable({
                columnDefs: [{orderable: false, targets: [4] }],
                order: [[2, 'asc'],[1, 'asc']],
            });

        });  // document ready

    </script>

@endsection