<?php

namespace Ignite\Claim\Events\Handlers;

use Ignite\Claim\Events\ClaimEvent;
use Ignite\Claim\Models\ClaimEmailSender;

// use Illuminate\Queue\InteractsWithQueue;
// use Illuminate\Contracts\Queue\ShouldQueue;

class ClaimEventHandler
{
    /** @var array */
    protected $allowedEvents = [
        'claim_approved',
        'claim_cancelled',
        'claim_declined',
        'claim_issued',
        'claim_submitted',
        'claim_submitted_split',
    ];

    /**
     * Handle Claim events.
     *
     * @param  ClaimEvent $event
     * @return bool
     * @throws \Ignite\Core\Entities\Exception
     */
    public function onClaimEvent($event)
    {
        if (app()->runningInConsole() && ! config('site.demo.allow_events_in_console')) {
            return false;
        }

        if (in_array($event->eventType, $this->allowedEvents)) {
            app(ClaimEmailSender::class)->handleEmailEvent($event);
        }
    }

    /**
     * Register the listeners for the subscriber.
     *
     * @param  \Illuminate\Events\Dispatcher $events
     */
    public function subscribe($events)
    {
        $events->listen(
            ClaimEvent::class,
            'Ignite\Claim\Events\Handlers\ClaimEventHandler@onClaimEvent'
        );
    }
}
