<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOfferPromotionToClaim extends Migration
{
    protected $tableName = 'claim';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('offer_promotion_id')->default(1);
            $table->index('offer_promotion_id');
            $table->foreign('offer_promotion_id')->references('id')->on('claim_offer_promotion');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->dropForeign('claim_offer_promotion_id_foreign');
            $table->dropIndex('claim_offer_promotion_id_index');
            $table->dropColumn('offer_promotion_id');
        });
    }
}
