(function (jQuery, window, document, undefined) {

    'use strict';

    jQuery(document).ready(function($){

        function clearClaimItemDialog()
        {
            claimItemValidator.resetForm();
            $('#claimItemDialog [data-name]').removeClass('error');

            var group = $('#claimItemOfferGroup');
            var groupReadonly = group.attr('readonly');
            if (!groupReadonly) {
                $('#claimItemOfferGroup').val('').trigger('change');
            }

            var name = $('#claimItemName');
            var nameReadonly = name.attr('readonly');
            if (!nameReadonly) {
                $('#claimItemName').val('').trigger('change');
            }

            var qty = $('#claimItemQty');
            var qtyReadonly = qty.attr('readonly');
            if (!qtyReadonly) {
                $('#claimItemQty').val('').trigger('change');
            }
        }

        function getClaimItemCount()
        {
            var count = 0;

            $('#claimItemsList tr.claimItem').each(function() {
                ++count;
            });

            return count;
        }

        function updateClaimItemCount()
        {
            var count = getClaimItemCount();

            $('#claimItemCount').html(count);
        }

        function checkMaxItemCount()
        {
            var itemCount = parseInt(getClaimItemCount(), 10);
            var maxItemCount = parseInt($('#maxLineitems').val(), 10);

            if (itemCount >= maxItemCount) {
                alert('You are only allowed to enter up to ' + maxItemCount + ' Claim Items.');
                return false;
            }

            return true;

            return true;
        }

        function setClaimItemButtons(mode)
        {
            $('#claimItemDialog .modal-header').removeClass('bg-default');
            $('#claimItemDialog .modal-header').removeClass('bg-success');

            if ( mode == 'add' ) {
                $('#claimItemDialog .modal-header').addClass('bg-success');
                $('#claimItemLabel').html('Add Claim Item');
                $('#claimItemSave').addClass('hidden');
                $('#claimItemSave').hide();
                $('#claimItemAdd').removeClass('hidden');
                $('#claimItemAdd').show();
            }
            else {
                $('#claimItemDialog .modal-header').addClass('bg-default');
                $('#claimItemLabel').html('Edit Claim Item');
                $('#claimItemAdd').addClass('hidden');
                $('#claimItemAdd').hide();
                $('#claimItemSave').removeClass('hidden');
                $('#claimItemSave').show();
            }
        }

        function deleteClaimItem(element)
        {
            $(element).closest('tr').remove();

            updateClaimItemCount();
        }

        $('#addClaimItem').click(function () {
            if (! checkMaxItemCount()) {
                return false;
            }

            clearClaimItemDialog();
            setClaimItemButtons('add');
            $('#claimItemDialog').modal('show');
        });

        function validateClaimItem() {
            var messages = '';

            $('#addClaimItemForm input[data-name][required]').each(function() {
                if ( $(this).val().trim() == '' ) {
                    var name = $(this).attr('data-name');
                    messages += name + ' is a required field.' + "\n";
                }
            });

            if (messages != '') {
                alert(messages);
                return false;
            }

            return true;
        }

        function buildClaimItemRow(itemCount)
        {
            var html = '<tr class="claimItem">' + "\n";
                html += '  <td name="itemNumber">' + itemCount + '</td>' + "\n";
                html += '  <input type="hidden" name="id" value="new" />' + "\n";

            $('#addClaimItemForm [data-name]').each(function() {
                var dataName = $(this).attr('data-name');
                var value = $(this).val();
                if ($(this).prop('tagName') == 'SELECT' && $(this).val() != $(this).find('option:selected').text()) {
                    value = $(this).find('option:selected').text();
                }

                var tempValue = $(this).attr('data-value');
                if (dataName == 'qty' && tempValue) {
                    value = tempValue;
                }

                if (dataName == 'offer_id') {
                    html += '<input type="hidden" name="' + dataName + '" value="' + value + '" />';
                } else {
                    html += '<td><input type="hidden" name="' + dataName + '" value="' + value + '" />' + value + '</td>';
                }
            });

            var editButton   = '<button type="button" class="btn btn-sm btn-default editClaimItem"><span class="text-info"><span class="fa fa-pencil"></span> Edit</span></button> ';
            var deleteButton = '<button type="button" class="btn btn-sm btn-default deleteClaimItem"><span class="text-danger"><span class="fa fa-trash"></span> Delete</span></button>';

            html += "<td class='text-right'>\n" + editButton + deleteButton + "  </td>";
            html += '</tr>';

            var $row = $(html);

            $row.find('.editClaimItem').click(function(){ editClaimItem(this); });
            $row.find('.deleteClaimItem').click(function(){ deleteClaimItem(this); });

            return $row;
        }

        function editClaimItem(element)
        {
            // Get the Claim Line Item selected
            var $row = $(element).closest('tr');
            var itemNumber = $row.find('[name="itemNumber"]').html();
            clearClaimItemDialog();
            setClaimItemButtons('edit');

            $('#claimItemSave').attr('data-item_number', itemNumber);

            // Populate the Edit Claim Item Dialog with the values from the Claim Line Item selected
            $('#addClaimItemForm [data-name]').each(function() {
                var dataName = $(this).attr('data-name');
                var dataValue = $(this).attr('data-value');
                var itemValue = $row.find('[name="'+dataName+'"]').val();
                $(this).val(itemValue);
                if ( $(this).prop('tagName') == 'SELECT' ) {
                    $(this).find("option").filter(function() {
                        return $(this).text() == itemValue;
                    }).prop('selected', true);

                   $(this).trigger('change');
                }
            });

            $('#claimItemDialog').modal('show');
        }

        $('#claimItemAdd').click(function() {
            if (! $("#addClaimItemForm").valid()) {
                return false;
            }

            if (! checkMaxItemCount()) {
                return false;
            }

            var itemCount = $('#claimItemsList tbody tr').length + 1;
            var $row = buildClaimItemRow(itemCount);

            $('#claimItemsList tbody').append($row);

            updateClaimItemCount();
            clearClaimItemDialog();

            $('#claimItemDialog').modal('hide');
        });

        $('#claimItemSave').click(function() {
            if (! $("#addClaimItemForm").valid()) {
                return false;
            }
            // Get Item Number that was being Edited from the Claim Line Item Dialog
            var itemNumber = $('#claimItemSave').attr('data-item_number');
            if (itemNumber == $('#maxLineitems').val()) {
                window.Ignite.Core.flash('Reached the maximum of ' + $('#maxLineitems').val() + ' allowed claim items.', 'info');
                return false;
            }

            // Build a new Row with the Data from the Claim Line Item Dialog
            var $row = buildClaimItemRow(itemNumber);

            // Find the Claim Line Item Dialog and replace it with the new Row
            var $claimLineItem = null;
            $('#claimItemsList tbody td[name="itemNumber"]').filter(function() {
                var html = $(this).html();
                if (html == itemNumber) {
                    $claimLineItem = $(this).closest('tr');
                    return false;
                }
            });

            $claimLineItem.replaceWith($row);

            return $('#claimItemDialog').modal('hide');
        });

        $('#claimItemOfferGroup').change(function() {
            var offerGroup = $(this).val();
            var offers = offerGroups[offerGroup];
            $('#claimItemName').empty();

            $('#claimItemName').append('<option value="">--- Select ---</option>');

            $(offers).each(function (index, offer) {
                $('#claimItemName').append('<option value="' + offer.offer_id + '">' + offer.name + '</option>');
            });
        });

        $('#claimItemName').change(function() {
            var $this = $(this);
            if ($this.prop('multiple')) {
                var names = [];
                $this.find('option:selected').each(function(idx) {
                    names.push($(this).text());
                });
                $('#claimItemOfferName').val(names.join('|'));
            }
            $('#claimItemOfferId').val($this.val());
        });

        $('.deleteClaimItem').click(function() {
            deleteClaimItem(this);
        });

        $('.editClaimItem').click(function() {
            editClaimItem(this);
        });

        var claimItemValidator = $('#addClaimItemForm').validate(window.validationConfig);
    });

})(window.jQuery, window, document);
