
<div id="filesVue">
    <form class="form-horizontal" method="POST" action="/file/store" enctype="multipart/form-data">
        {{ csrf_field() }}
        <input type="hidden" id="filesCode" name="filesCode" value="{{ $filesCode }}" />
        <div class="panel{{ !empty($isAdminLayout) ? ' panel-default' : '' }}">
            <div class="panel-heading">
                <div class="panel-title row">
                    <div class="col-md-6">
                        <strong>{{ __('Claim::claim.documents.heading') }}</strong>
                        <span class="badge badge-success" v-text="files.length"></span>
                    </div>
                    <div class="col-md-6 text-right pull-right">
                        <button type="button" class="btn btn-sm btn-success" @click.prevent="addFile()">{{ __('Claim::claim.documents.actions.add') }}</button>
                    </div>
                </div>
            </div>
            <div class="panel-body">
                @include('claim.partials.files_instructions')

                <table class="table table-responsive" v-if="files.length">
                    <thead>
                        <tr>
                            <th>{{ __('Claim::claim.documents.type') }}</th>
                            <th>{{ __('Claim::claim.documents.file') }}</th>
                            <th>&nbsp;</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="(file, idx) in files">
                            <td class="col-md-3">
                                <input type="hidden" v-model="file.fileId" :value="file.fileId" />
                                <select class="form-control" v-model="file.documentType" @change="changeDocumentType(file, $event)">
                                    <option :value="''">{{ __('Core::core.select.default') }}</option>
                                  @foreach($documentTypes as $documentType)
                                    <option :value="'{{ $documentType['name'] }}'">{{ $documentType['name'] }}</option>
                                  @endforeach
                                </select>
                            </td>
                            <td class="col-md-7">
                                <input class="form-control" type="file" :name="'files[' + idx + ']'" v-if="file.storeFileName == ''" @change="changedFile(file, $event)" />
                                <input class="form-control" type="text" :name="'files[' + idx + ']'" v-else :value="file.fileName" readOnly />
                            </td>
                            <td class="col-md-1">
                                <button type="button" class="btn btn-sm btn-default" @click.prevent="deleteFile(file)">
                                    <span class="text-danger"><span class="fa fa-trash"></span> {{ __('Claim::claim.documents.actions.delete') }}</span>
                                </button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </form>
</div>
@section('js')
@include('Claim::partials.vue')
<script>
documentTypes = {!! json_encode($documentTypes, JSON_PRETTY_PRINT) !!};
documentSuffixes = {!! json_encode($documentSuffixes, JSON_PRETTY_PRINT) !!};
uploadedFiles = {!! json_encode($uploadFiles, JSON_PRETTY_PRINT) !!};
</script>
<script src="{{ asset('/vendor/ignite/js/claim/claimFiles.js') }}"></script>
@parent
@endsection
