<?php

namespace Ignite\Claim\Events;

use Illuminate\Queue\SerializesModels;

class ClaimCreated
{
    use SerializesModels;

    /**
     * @var int
     */
    public $claimId;

    /**
     * Create a new event instance.
     *
     * @param int $claimId
     */
    public function __construct($claimId)
    {
        $this->claimId = $claimId;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
